/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import org.apache.flink.table.dataformat.vector.BooleanColumnVector;
import org.apache.flink.table.dataformat.vector.ByteColumnVector;
import org.apache.flink.table.dataformat.vector.BytesColumnVector;
import org.apache.flink.table.dataformat.vector.ColumnVector;
import org.apache.flink.table.dataformat.vector.DoubleColumnVector;
import org.apache.flink.table.dataformat.vector.FloatColumnVector;
import org.apache.flink.table.dataformat.vector.IntegerColumnVector;
import org.apache.flink.table.dataformat.vector.LongColumnVector;
import org.apache.flink.table.dataformat.vector.ShortColumnVector;
import org.apache.flink.table.sources.parquet.VectorizedRleValuesReaderBase;
import org.apache.flink.table.sources.parquet.VectorizedValuesReader;

public final class VectorizedDefValuesReader
extends VectorizedRleValuesReaderBase {
    public VectorizedDefValuesReader(int bitWidth) {
        super(bitWidth);
    }

    public boolean readBoolean() {
        return this.readInteger() != 0;
    }

    @Override
    public void skip() {
        this.readInteger();
    }

    public void readBooleans(int total, BooleanColumnVector c, int rowId, int level, VectorizedValuesReader data) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readBooleans(n, c, rowId);
                        break;
                    }
                    for (int index = rowId; index < rowId + n; ++index) {
                        c.isNull[index] = true;
                    }
                    c.noNulls = false;
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.vector[rowId + i] = data.readBoolean();
                            continue;
                        }
                        c.noNulls = false;
                        c.isNull[rowId + i] = true;
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readBytes(int total, ByteColumnVector c, int rowId, int level, VectorizedValuesReader data) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readBytes(n, c, rowId);
                        break;
                    }
                    for (int index = rowId; index < rowId + n; ++index) {
                        c.isNull[index] = true;
                    }
                    c.noNulls = false;
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.vector[rowId + i] = data.readByte();
                            continue;
                        }
                        c.noNulls = false;
                        c.isNull[rowId + i] = true;
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readShorts(int total, ShortColumnVector c, int rowId, int level, VectorizedValuesReader data) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    int i;
                    if (this.currentValue == level) {
                        for (i = 0; i < n; ++i) {
                            c.vector[rowId + i] = (short)data.readInteger();
                        }
                        break;
                    }
                    for (int index = rowId; index < rowId + n; ++index) {
                        c.isNull[index] = true;
                    }
                    c.noNulls = false;
                    break;
                }
                case PACKED: {
                    int i;
                    for (i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.vector[rowId + i] = (short)data.readInteger();
                            continue;
                        }
                        c.noNulls = false;
                        c.isNull[rowId + i] = true;
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readLongs(int total, LongColumnVector c, int rowId, int level, VectorizedValuesReader data) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readLongs(n, c, rowId);
                        break;
                    }
                    for (int index = rowId; index < rowId + n; ++index) {
                        c.isNull[index] = true;
                    }
                    c.noNulls = false;
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.vector[rowId + i] = data.readLong();
                            continue;
                        }
                        c.noNulls = false;
                        c.isNull[rowId + i] = true;
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readFloats(int total, FloatColumnVector c, int rowId, int level, VectorizedValuesReader data) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readFloats(n, c, rowId);
                        break;
                    }
                    for (int index = rowId; index < rowId + n; ++index) {
                        c.isNull[index] = true;
                    }
                    c.noNulls = false;
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.vector[rowId + i] = data.readFloat();
                            continue;
                        }
                        c.noNulls = false;
                        c.isNull[rowId + i] = true;
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readDoubles(int total, DoubleColumnVector c, int rowId, int level, VectorizedValuesReader data) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readDoubles(n, c, rowId);
                        break;
                    }
                    for (int index = rowId; index < rowId + n; ++index) {
                        c.isNull[index] = true;
                    }
                    c.noNulls = false;
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.vector[rowId + i] = data.readDouble();
                            continue;
                        }
                        c.noNulls = false;
                        c.isNull[rowId + i] = true;
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readBinaries(int total, BytesColumnVector c, int rowId, int level, VectorizedValuesReader data) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readBinaries(n, c, rowId);
                        break;
                    }
                    for (int index = rowId; index < rowId + n; ++index) {
                        c.isNull[index] = true;
                    }
                    c.noNulls = false;
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            data.readBinaries(1, c, rowId + i);
                            continue;
                        }
                        c.noNulls = false;
                        c.isNull[rowId + i] = true;
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readIntegers(int total, IntegerColumnVector c, ColumnVector nulls, int rowId, int level, VectorizedValuesReader data) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readIntegers(n, c, rowId);
                        break;
                    }
                    for (int index = rowId; index < rowId + n; ++index) {
                        nulls.isNull[index] = true;
                    }
                    nulls.noNulls = false;
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.vector[rowId + i] = data.readInteger();
                            continue;
                        }
                        nulls.noNulls = false;
                        nulls.isNull[rowId + i] = true;
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    public void readIntegers(int total, IntegerColumnVector c, int rowId, int level, VectorizedValuesReader data) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    if (this.currentValue == level) {
                        data.readIntegers(n, c, rowId);
                        break;
                    }
                    for (int index = rowId; index < rowId + n; ++index) {
                        c.isNull[index] = true;
                    }
                    c.noNulls = false;
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.currentBuffer[this.currentBufferIdx++] == level) {
                            c.vector[rowId + i] = data.readInteger();
                            continue;
                        }
                        c.noNulls = false;
                        c.isNull[rowId + i] = true;
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }
}

