/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.sources.parquet.ParquetInputFormat;
import org.apache.flink.table.sources.parquet.ParquetVectorizedRowReader;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.types.Row;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.parquet.filter2.predicate.FilterPredicate;

public class VectorizedRowInputParquetFormat
extends ParquetInputFormat<Row, Row>
implements ResultTypeQueryable<Row> {
    private static final long serialVersionUID = -2569974518641072883L;
    private transient Row reuse;

    public VectorizedRowInputParquetFormat(Path filePath, InternalType[] fieldTypes2, String[] fieldNames) {
        super(filePath, fieldTypes2, fieldNames);
    }

    @Override
    protected RecordReader createReader(FilterPredicate filter) {
        return new ParquetVectorizedRowReader(this.fieldTypes, this.fieldNames);
    }

    public RowTypeInfo getProducedType() {
        return new RowTypeInfo(TypeConverters.createExternalTypeInfoFromDataTypes(this.fieldTypes));
    }

    @Override
    protected Row convert(Row current) {
        if (this.reuse == null) {
            return Row.copy(current);
        }
        for (int i = 0; i < current.getArity(); ++i) {
            this.reuse.setField(i, current.getField(i));
        }
        return this.reuse;
    }
}

