/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.temptable;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.service.ServiceDescriptor;
import org.apache.flink.service.ServiceInstance;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.plan.CacheAwareRelNodePlanBuilder;
import org.apache.flink.table.plan.logical.LogicalNode;
import org.apache.flink.table.plan.logical.SinkNode;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.temptable.TableServiceOptions;
import org.apache.flink.table.temptable.rpc.TableServiceClient;
import org.apache.flink.table.temptable.rpc.TableServiceRegistry;
import org.apache.flink.table.temptable.util.TableServiceUtil;
import org.apache.flink.table.util.TableProperties;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.MutableList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001B\u0001\u0003\u00015\u0011\u0001D\u00127j].$\u0016M\u00197f'\u0016\u0014h/[2f\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0005uK6\u0004H/\u00192mK*\u0011QAB\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000f!\tQA\u001a7j].T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0003u\u000b:4\bCA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\r\t\u0007/[\u0005\u00037a\u0011\u0001\u0003V1cY\u0016,eN^5s_:lWM\u001c;\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0012\u0005\u0005\u0002!\u00015\t!\u0001C\u0003\u00169\u0001\u0007a\u0003C\u0004$\u0001\t\u0007I\u0011\u0002\u0013\u0002!Q|')Z\"bG\",G\rV1cY\u0016\u001cX#A\u0013\u0011\t\u0019ZS&N\u0007\u0002O)\u0011\u0001&K\u0001\u0005kRLGNC\u0001+\u0003\u0011Q\u0017M^1\n\u00051:#aD%eK:$\u0018\u000e^=ICNDW*\u00199\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003e\u0011\tA\u0001\u001d7b]&\u0011Ag\f\u0002\f\u0019><\u0017nY1m\u001d>$W\r\u0005\u00027s9\u0011qbN\u0005\u0003qA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001\b\u0005\u0005\u0007{\u0001\u0001\u000b\u0011B\u0013\u0002#Q|')Z\"bG\",G\rV1cY\u0016\u001c\b\u0005\u0003\u0005@\u0001\t\u0007I\u0011\u0001\u0004%\u00031\u0019\u0017m\u00195fIR\u000b'\r\\3t\u0011\u0019\t\u0005\u0001)A\u0005K\u0005i1-Y2iK\u0012$\u0016M\u00197fg\u0002B\u0001b\u0011\u0001A\u0002\u0013\u0005a\u0001R\u0001\u0014i\u0006\u0014G.Z*feZL7-Z*uCJ$X\rZ\u000b\u0002\u000bB\u0011qBR\u0005\u0003\u000fB\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005J\u0001\u0001\u0007I\u0011\u0001\u0004K\u0003]!\u0018M\u00197f'\u0016\u0014h/[2f'R\f'\u000f^3e?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011q\u0002T\u0005\u0003\u001bB\u0011A!\u00168ji\"9q\nSA\u0001\u0002\u0004)\u0015a\u0001=%c!1\u0011\u000b\u0001Q!\n\u0015\u000bA\u0003^1cY\u0016\u001cVM\u001d<jG\u0016\u001cF/\u0019:uK\u0012\u0004\u0003BC*\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0007)\u0006a1/\u001e2nSR\u0014Vm];miV\tQ\u000b\u0005\u0002W56\tqK\u0003\u0002Y3\u000611m\\7n_:T!!\u0007\u0004\n\u0005m;&a\u0005&pEN+(-\\5tg&|gNU3tk2$\bBC/\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0007=\u0006\u00012/\u001e2nSR\u0014Vm];mi~#S-\u001d\u000b\u0003\u0017~Cqa\u0014/\u0002\u0002\u0003\u0007Q\u000b\u0003\u0004b\u0001\u0001\u0006K!V\u0001\u000egV\u0014W.\u001b;SKN,H\u000e\u001e\u0011\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0013!\u0017a\u0004;bE2,7+\u001a:wS\u000e,WI\u001c<\u0016\u0003\u0015\u0004\"A\u001a7\u000e\u0003\u001dT!\u0001[5\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\u0006\u00033)T!a\u001b\u0004\u0002\u0013M$(/Z1nS:<\u0017BA7h\u0005i\u0019FO]3b[\u0016CXmY;uS>tWI\u001c<je>tW.\u001a8u\u0011%y\u0007\u00011AA\u0002\u0013%\u0001/A\nuC\ndWmU3sm&\u001cW-\u00128w?\u0012*\u0017\u000f\u0006\u0002Lc\"9qJ\\A\u0001\u0002\u0004)\u0007BB:\u0001A\u0003&Q-\u0001\tuC\ndWmU3sm&\u001cW-\u00128wA!AQ\u000f\u0001EC\u0002\u0013%a/\u0001\buC\ndWmU3sm&\u001cW-\u00133\u0016\u0003UB\u0001\u0002\u001f\u0001\t\u0002\u0003\u0006K!N\u0001\u0010i\u0006\u0014G.Z*feZL7-Z%eA!I!\u0010\u0001a\u0001\u0002\u0004%Ia_\u0001\u0015i\u0006\u0014G.Z*feZL7-\u001a*fO&\u001cHO]=\u0016\u0003q\u00042!`A\u0001\u001b\u0005q(BA@\u0003\u0003\r\u0011\boY\u0005\u0004\u0003\u0007q(\u0001\u0006+bE2,7+\u001a:wS\u000e,'+Z4jgR\u0014\u0018\u0010C\u0006\u0002\b\u0001\u0001\r\u00111A\u0005\n\u0005%\u0011\u0001\u0007;bE2,7+\u001a:wS\u000e,'+Z4jgR\u0014\u0018p\u0018\u0013fcR\u00191*a\u0003\t\u0011=\u000b)!!AA\u0002qDq!a\u0004\u0001A\u0003&A0A\u000buC\ndWmU3sm&\u001cWMU3hSN$(/\u001f\u0011\t\u0017\u0005M\u0001\u00011AA\u0002\u0013%\u0011QC\u0001\u0013i\u0006\u0014G.Z*feZL7-Z\"mS\u0016tG/\u0006\u0002\u0002\u0018A\u0019Q0!\u0007\n\u0007\u0005maP\u0001\nUC\ndWmU3sm&\u001cWm\u00117jK:$\bbCA\u0010\u0001\u0001\u0007\t\u0019!C\u0005\u0003C\ta\u0003^1cY\u0016\u001cVM\u001d<jG\u0016\u001cE.[3oi~#S-\u001d\u000b\u0004\u0017\u0006\r\u0002\"C(\u0002\u001e\u0005\u0005\t\u0019AA\f\u0011!\t9\u0003\u0001Q!\n\u0005]\u0011a\u0005;bE2,7+\u001a:wS\u000e,7\t\\5f]R\u0004\u0003bBA\u0016\u0001\u0011\u0005\u0011QF\u0001\u0017O\u0016$H+\u00192mKN+'O^5dK\u001a\u000b7\r^8ssR\u0011\u0011q\u0006\t\u0006\u001f\u0005E\u0012QG\u0005\u0004\u0003g\u0001\"AB(qi&|g\u000e\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tY\u0004B\u0001\nM\u0006\u001cGo\u001c:jKNLA!a\u0010\u0002:\taA+\u00192mK\u001a\u000b7\r^8ss\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013\u0001I4fiR\u000b'\r\\3TKJ4\u0018nY3GC\u000e$xN]=Qe>\u0004XM\u001d;jKN$\"!a\u0012\u0011\u000b=\t\t$!\u0013\u0011\t\u0005-\u0013qJ\u0007\u0003\u0003\u001bR!\u0001\u000b\u0003\n\t\u0005E\u0013Q\n\u0002\u0010)\u0006\u0014G.\u001a)s_B,'\u000f^5fg\"9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0013!G4fiR\u000b'\r\\3TKJ4\u0018nY3EKN\u001c'/\u001b9u_J$\"!!\u0017\u0011\u000b=\t\t$a\u0017\u0011\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019\u0007\u0003\u001d\u0019XM\u001d<jG\u0016LA!!\u001a\u0002`\t\t2+\u001a:wS\u000e,G)Z:de&\u0004Ho\u001c:\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l\u00059r-\u001a;UC\ndWmU3sm&\u001cW-\u00138ti\u0006t7-\u001a\u000b\u0003\u0003[\u0002rAJA8\u0003g\ny(C\u0002\u0002r\u001d\u00121!T1q!\u0011\t)(a\u001f\u000e\u0005\u0005]$bAA=S\u0005!A.\u00198h\u0013\u0011\ti(a\u001e\u0003\u000f%sG/Z4feB!\u0011QLAA\u0013\u0011\t\u0019)a\u0018\u0003\u001fM+'O^5dK&s7\u000f^1oG\u0016D!\"a\"\u0001\u0005\u0004%\tABAE\u0003A\u0019\u0017m\u00195f!2\fgNQ;jY\u0012,'/\u0006\u0002\u0002\fB!\u0011QRAH\u001b\u0005\t\u0014bAAIc\ta2)Y2iK\u0006;\u0018M]3SK2tu\u000eZ3QY\u0006t')^5mI\u0016\u0014\b\u0002CAK\u0001\u0001\u0006I!a#\u0002#\r\f7\r[3QY\u0006t')^5mI\u0016\u0014\b\u0005C\u0004\u0002\u001a\u0002!I!a'\u0002\u0015\r\f7\r[3UC\ndW\rF\u0003L\u0003;\u000b)\u000bC\u0004\u0006\u0003/\u0003\r!a(\u0011\u0007]\t\t+C\u0002\u0002$b\u0011Q\u0001V1cY\u0016Dq!a*\u0002\u0018\u0002\u0007Q'A\u0005uC\ndW-V+J\t\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005-FcA&\u0002.\"9Q!!+A\u0002\u0005}\u0005bBAY\u0001\u0011\u0005\u00111W\u0001\u0010S:4\u0018\r\\5eCR,7)Y2iKR\u00191*!.\t\u000f\u0015\ty\u000b1\u0001\u0002 \"9\u0011\u0011\u0018\u0001\u0005\n\u0005m\u0016a\u00033fY\u0016$X\rV1cY\u0016$2aSA_\u0011\u001d\t9+a.A\u0002UB\u0001\"!1\u0001\t\u0003\u0011\u00111Y\u0001\u0015k:\u0014XmZ5ti\u0016\u0014\b+\u0019:uSRLwN\\:\u0015\u0007-\u000b)\rC\u0004\u0006\u0003\u007f\u0003\r!a(\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\u0006)\u0012N\u001c<bY&$\u0017\r^3DC\u000eDW\r\u001a+bE2,G#A&\t\u0011\u0005=\u0007\u0001\"\u0001\u0007\u0003\u0017\f1#\\1sW\u0006cG\u000eV1cY\u0016\u001c8)Y2iK\u0012D\u0001\"a5\u0001\t\u00031\u0011Q[\u0001\u0017O\u0016$Hk\u001c\"f\u0007\u0006\u001c\u0007.\u001a3UC\ndWMT1nKR!\u0011q[Am!\u0011y\u0011\u0011G\u001b\t\u000f\u0005m\u0017\u0011\u001ba\u0001[\u0005YAn\\4jG\u0006d\u0007\u000b\\1o\u0011!\ty\u000e\u0001C\u0001\r\u0005\u0005\u0018AE4fi\u000e\u000b7\r[3e)\u0006\u0014G.\u001a(b[\u0016$B!a6\u0002d\"9\u00111\\Ao\u0001\u0004i\u0003bBAt\u0001\u0011\u0005\u00111Z\u0001\u0015gR\f'\u000f\u001e+bE2,7+\u001a:wS\u000e,'j\u001c2\t\u000f\u0005-\b\u0001\"\u0001\u0002n\u0006\tr-\u001a;UC\ndWmU3sm&\u001cW-\u00133\u0015\u0003UB\u0001\"!=\u0001\t\u00031\u00111_\u0001\u001fgR\f'\u000f\u001e+bE2,7+\u001a:wS\u000e,'j\u001c2J]R,'O\\1mYf$2aSA{\u0011!\t90a<A\u0002\u0005m\u0013A\u00033fg\u000e\u0014\u0018\u000e\u001d;pe\"\"\u0011q^A~!\u0011\tiPa\u0001\u000e\u0005\u0005}(b\u0001B\u0001\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015\u0011q \u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0007b\u0002B\u0005\u0001\u0011\u0005\u00111Z\u0001\u0006G2|7/\u001a\u0005\b\u0005\u001b\u0001A\u0011BAf\u0003)Ig.\u001b;DY&,g\u000e\u001e")
public class FlinkTableServiceManager {
    public final TableEnvironment org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv;
    private final IdentityHashMap<LogicalNode, String> toBeCachedTables;
    private final IdentityHashMap<LogicalNode, String> cachedTables;
    private boolean tableServiceStarted;
    private JobSubmissionResult submitResult;
    private StreamExecutionEnvironment tableServiceEnv;
    private String tableServiceId;
    private TableServiceRegistry tableServiceRegistry;
    private TableServiceClient org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient;
    private final CacheAwareRelNodePlanBuilder cachePlanBuilder;
    private volatile boolean bitmap$0;

    private String tableServiceId$lzycompute() {
        FlinkTableServiceManager flinkTableServiceManager = this;
        synchronized (flinkTableServiceManager) {
            if (!this.bitmap$0) {
                this.tableServiceId = UUID.randomUUID().toString();
                this.bitmap$0 = true;
            }
            return this.tableServiceId;
        }
    }

    private IdentityHashMap<LogicalNode, String> toBeCachedTables() {
        return this.toBeCachedTables;
    }

    public IdentityHashMap<LogicalNode, String> cachedTables() {
        return this.cachedTables;
    }

    public boolean tableServiceStarted() {
        return this.tableServiceStarted;
    }

    public void tableServiceStarted_$eq(boolean x$1) {
        this.tableServiceStarted = x$1;
    }

    public JobSubmissionResult submitResult() {
        return this.submitResult;
    }

    public void submitResult_$eq(JobSubmissionResult x$1) {
        this.submitResult = x$1;
    }

    private StreamExecutionEnvironment tableServiceEnv() {
        return this.tableServiceEnv;
    }

    private void tableServiceEnv_$eq(StreamExecutionEnvironment x$1) {
        this.tableServiceEnv = x$1;
    }

    private String tableServiceId() {
        return this.bitmap$0 ? this.tableServiceId : this.tableServiceId$lzycompute();
    }

    private TableServiceRegistry tableServiceRegistry() {
        return this.tableServiceRegistry;
    }

    private void tableServiceRegistry_$eq(TableServiceRegistry x$1) {
        this.tableServiceRegistry = x$1;
    }

    public TableServiceClient org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient() {
        return this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient;
    }

    private void org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient_$eq(TableServiceClient x$1) {
        this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient = x$1;
    }

    public Option<TableFactory> getTableServiceFactory() {
        return Option$.MODULE$.apply((Object)this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.getConfig().getTableServiceFactoryDescriptor().getTableFactory());
    }

    public Option<TableProperties> getTableServiceFactoryProperties() {
        return Option$.MODULE$.apply((Object)this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.getConfig().getTableServiceFactoryDescriptor().getTableProperties());
    }

    public Option<ServiceDescriptor> getTableServiceDescriptor() {
        return Option$.MODULE$.apply((Object)this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.getConfig().getTableServiceDescriptor());
    }

    public Map<Integer, ServiceInstance> getTableServiceInstance() {
        return this.tableServiceRegistry().getRegistedServices();
    }

    public CacheAwareRelNodePlanBuilder cachePlanBuilder() {
        return this.cachePlanBuilder;
    }

    public void org$apache$flink$table$temptable$FlinkTableServiceManager$$cacheTable(Table table, String tableUUID) {
        this.toBeCachedTables().put(table.logicalPlan(), tableUUID);
        TableSink<?> cacheSink = this.cachePlanBuilder().createCacheTableSink(tableUUID, table.logicalPlan());
        this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.writeToSink(table, cacheSink, tableUUID);
        TableSource cacheSource = this.cachePlanBuilder().createCacheTableSource(tableUUID, table.logicalPlan());
        if (this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.getTable(tableUUID).isEmpty()) {
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.registerTableSource(tableUUID, cacheSource);
        }
    }

    public void cacheTable(Table table) {
        String name = UUID.randomUUID().toString();
        this.org$apache$flink$table$temptable$FlinkTableServiceManager$$cacheTable(table, name);
    }

    public void invalidateCache(Table table) {
        if (this.toBeCachedTables().containsKey(table.logicalPlan())) {
            String uuid2 = this.toBeCachedTables().get(table.logicalPlan());
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.sinkNodes_$eq((MutableList<SinkNode>)((MutableList)this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.sinkNodes().filter((Function1)new Serializable(this, uuid2){
                public static final long serialVersionUID = 0L;
                private final String uuid$1;

                public final boolean apply(SinkNode x$1) {
                    String string = x$1.sinkName();
                    String string2 = this.uuid$1;
                    return string != null ? !string.equals(string2) : string2 != null;
                }
                {
                    this.uuid$1 = uuid$1;
                }
            })));
            this.toBeCachedTables().remove(table.logicalPlan());
        } else if (this.cachedTables().containsKey(table.logicalPlan())) {
            String uuid3 = this.cachedTables().get(table.logicalPlan());
            this.deleteTable(uuid3);
            this.cachedTables().remove(table.logicalPlan());
        }
    }

    private void deleteTable(String tableUUID) {
        if (this.tableServiceRegistry() != null) {
            this.initClient();
            List<Integer> partitions = this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient().getPartitions(tableUUID);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitions).asScala()).foreach((Function1)new Serializable(this, tableUUID){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FlinkTableServiceManager $outer;
                private final String tableUUID$1;

                public final void apply(Integer partition2) {
                    this.$outer.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient().deletePartition(this.tableUUID$1, Predef$.MODULE$.Integer2int(partition2));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tableUUID$1 = tableUUID$1;
                }
            });
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient().unregisterPartitions(tableUUID);
        }
    }

    public void unregisterPartitions(Table table) {
        if (this.cachedTables().containsKey(table.logicalPlan())) {
            String uuid2 = this.cachedTables().get(table.logicalPlan());
            this.initClient();
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient().unregisterPartitions(uuid2);
        }
    }

    public void invalidateCachedTable() {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.cachedTables()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkTableServiceManager $outer;

            public final void apply(Tuple2<LogicalNode, String> x0$1) {
                Tuple2<LogicalNode, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    LogicalNode plan = (LogicalNode)tuple2._1();
                    String name = (String)tuple2._2();
                    this.$outer.org$apache$flink$table$temptable$FlinkTableServiceManager$$cacheTable(new Table(this.$outer.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv, plan), name);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.cachedTables().clear();
    }

    public void markAllTablesCached() {
        this.cachedTables().putAll(this.toBeCachedTables());
        this.toBeCachedTables().clear();
    }

    public Option<String> getToBeCachedTableName(LogicalNode logicalPlan) {
        return Option$.MODULE$.apply((Object)this.toBeCachedTables().get(logicalPlan));
    }

    public Option<String> getCachedTableName(LogicalNode logicalPlan) {
        return Option$.MODULE$.apply((Object)this.cachedTables().get(logicalPlan));
    }

    public void startTableServiceJob() {
        if (!this.toBeCachedTables().isEmpty()) {
            ServiceDescriptor descriptor = (ServiceDescriptor)this.getTableServiceDescriptor().get();
            this.startTableServiceJobInternally(descriptor);
        }
    }

    public String getTableServiceId() {
        return this.tableServiceId();
    }

    @VisibleForTesting
    public void startTableServiceJobInternally(ServiceDescriptor descriptor) {
        if (!this.tableServiceStarted()) {
            this.tableServiceRegistry_$eq(new TableServiceRegistry(descriptor.getServiceParallelism()));
            this.tableServiceRegistry().open(descriptor.getConfiguration());
            TableServiceUtil.checkRegistryServiceReady(this.tableServiceRegistry(), descriptor.getConfiguration().getInteger(TableServiceOptions.TABLE_REGISTRY_READY_RETRY_TIMES), descriptor.getConfiguration().getLong(TableServiceOptions.TABLE_REGISTRY_READY_RETRY_BACKOFF_MS));
            descriptor.getConfiguration().setString(TableServiceOptions.TABLE_SERVICE_REGISTRY_ADDRESS, this.tableServiceRegistry().getIp());
            descriptor.getConfiguration().setInteger(TableServiceOptions.TABLE_SERVICE_REGISTRY_PORT, this.tableServiceRegistry().getPort());
            StreamExecutionEnvironment executionEnv = StreamExecutionEnvironment.getExecutionEnvironment();
            executionEnv.setRestartStrategy(RestartStrategies.fixedDelayRestart(Integer.MAX_VALUE, 500L));
            descriptor.getConfiguration().setString(TableServiceOptions.TABLE_SERVICE_ID, this.tableServiceId());
            TableServiceUtil.createTableServiceJob(executionEnv, descriptor);
            this.submitResult_$eq(executionEnv.submit("FlinkTableServiceJob"));
            this.tableServiceStarted_$eq(true);
            this.tableServiceEnv_$eq(executionEnv);
            TableServiceUtil.checkTableServiceReady(this.tableServiceRegistry(), descriptor.getConfiguration().getInteger(TableServiceOptions.TABLE_SERVICE_READY_RETRY_TIMES), descriptor.getConfiguration().getLong(TableServiceOptions.TABLE_SERVICE_READY_RETRY_BACKOFF_MS));
        }
    }

    public void close() {
        if (this.tableServiceStarted()) {
            this.tableServiceEnv().stopJob(this.submitResult().getJobID());
            this.tableServiceStarted_$eq(false);
        }
        if (this.tableServiceRegistry() != null) {
            this.tableServiceRegistry().close();
            this.tableServiceRegistry_$eq(null);
        }
        if (this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient() != null) {
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient().close();
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient_$eq(null);
        }
    }

    private void initClient() {
        if (this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient() == null) {
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient_$eq(new TableServiceClient());
            Configuration config = new Configuration();
            TableServiceUtil.injectTableServiceInstances(this.tableServiceRegistry().getRegistedServices(), config);
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient().open(config);
        }
    }

    public FlinkTableServiceManager(TableEnvironment tEnv) {
        this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv = tEnv;
        this.toBeCachedTables = new IdentityHashMap();
        this.cachedTables = new IdentityHashMap();
        this.tableServiceStarted = false;
        this.cachePlanBuilder = new CacheAwareRelNodePlanBuilder(tEnv);
    }
}

