/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.temptable;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.temptable.FlinkTableService;

@PublicEvolving
public final class TableServiceOptions {
    public static final ConfigOption<String> TABLE_SERVICE_CLASS_NAME = ConfigOptions.key("flink.service.table.service.class.name").defaultValue(FlinkTableService.class.getCanonicalName()).withDescription("Specify the table service class name, this class must have a default constructor.");
    public static final ConfigOption<Integer> TABLE_SERVICE_PARALLELISM = ConfigOptions.key("flink.service.table.service.parallelism").defaultValue(1).withDescription("Specify the parallelism of TableService.");
    public static final ConfigOption<Integer> TABLE_SERVICE_HEAP_MEMORY_MB = ConfigOptions.key("flink.service.table.service.heap.memory.mb").defaultValue(256).withDescription("Specify the heap memory (in megabytes) of TableService.");
    public static final ConfigOption<Integer> TABLE_SERVICE_DIRECT_MEMORY_MB = ConfigOptions.key("flink.service.table.service.direct.memory.mb").defaultValue(64).withDescription("Specify the direct memory (in megabytes) of TableService.");
    public static final ConfigOption<Integer> TABLE_SERVICE_NATIVE_MEMORY_MB = ConfigOptions.key("flink.service.table.service.native.memory.mb").defaultValue(64).withDescription("Specify the native memory (in megabytes) of TableService.");
    public static final ConfigOption<Double> TABLE_SERVICE_CPU_CORES = ConfigOptions.key("flink.service.table.service.cpu.cores").defaultValue(0.1).withDescription("Specify the cpu cores of TableService.");
    public static final ConfigOption<Integer> TABLE_SERVICE_READY_RETRY_TIMES = ConfigOptions.key("flink.service.table.service.ready.retry.times").defaultValue(10).withDescription("How many times the TableServiceClient will retry to check TableService's status.");
    public static final ConfigOption<Long> TABLE_SERVICE_READY_RETRY_BACKOFF_MS = ConfigOptions.key("flink.service.table.service.ready.backoff.ms").defaultValue(3000L).withDescription("How long the TableServiceClient will wait before the next retry.");
    public static final ConfigOption<Integer> TABLE_REGISTRY_READY_RETRY_TIMES = ConfigOptions.key("flink.service.table.registry.ready.retry.times").defaultValue(10).withDescription("How many times the table service manager will retry to check RegistryService's status.");
    public static final ConfigOption<Long> TABLE_REGISTRY_READY_RETRY_BACKOFF_MS = ConfigOptions.key("flink.service.table.registry.ready.backoff.ms").defaultValue(1000L).withDescription("How long the table service manager will wait before the next retry.");
    public static final ConfigOption<String> TABLE_SERVICE_ID = ConfigOptions.key("flink.service.table.service.id").noDefaultValue();
    public static final ConfigOption<String> TABLE_SERVICE_STORAGE_ROOT_PATH = ConfigOptions.key("flink.service.table.service.storage.root.path").noDefaultValue().withDescription("Specify the root path for table storage, System.getProperty(\"user.dir\") will be used if not specified.");
    public static final ConfigOption<Integer> TABLE_SERVICE_CLIENT_READ_BUFFER_SIZE = ConfigOptions.key("flink.service.table.service.client.read.buffer.size").defaultValue(0x400000).withDescription("Specify the read buffer size (in bytes) for TableServiceClient.");
    public static final ConfigOption<Integer> TABLE_SERVICE_CLIENT_WRITE_BUFFER_SIZE = ConfigOptions.key("flink.service.table.service.client.write.buffer.size").defaultValue(0x400000).withDescription("Specify the write buffer size (in bytes) for TableServiceClient.");
    public static final ConfigOption<String> TABLE_SERVICE_REGISTRY_ADDRESS = ConfigOptions.key("flink.service.table.service.registry.address").noDefaultValue().withDescription("");
    public static final ConfigOption<Integer> TABLE_SERVICE_REGISTRY_PORT = ConfigOptions.key("flink.service.table.service.registry.port").defaultValue(-1).withDescription("");
    public static final ConfigOption<String> TABLE_SERVICE_INSTANCES = ConfigOptions.key("flink.service.table.service.instances").noDefaultValue().withDescription("");

    private TableServiceOptions() {
    }
}

