/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.temptable.rpc;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.flink.table.temptable.TableServiceException;
import org.apache.flink.table.temptable.rpc.TableServiceMessage;
import org.apache.flink.table.temptable.util.BytesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableServiceClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TableServiceClientHandler.class);
    private ChannelHandlerContext context;
    private List<Integer> getPartitionsResult;
    private int writeResult;
    private byte lastRequest;
    private String errorMsg;
    private boolean hasError;

    public synchronized void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.context = ctx;
        ((Object)((Object)this)).notify();
    }

    private synchronized void ensureConnectionReady() throws Exception {
        while (this.context == null) {
            ((Object)((Object)this)).wait();
        }
    }

    public synchronized void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buffer = (ByteBuf)msg;
        byte[] responseBytes = new byte[buffer.readableBytes()];
        buffer.readBytes(responseBytes);
        byte response = responseBytes[0];
        if (response == 0) {
            switch (this.lastRequest) {
                case 1: {
                    this.handleGetPartitionsResult(responseBytes);
                    break;
                }
                case 2: {
                    this.handleWriteResult(responseBytes);
                    break;
                }
                case 3: {
                    this.handleVoidResult();
                    break;
                }
                case 4: {
                    this.handleVoidResult();
                    break;
                }
                case 5: {
                    this.handleVoidResult();
                    break;
                }
                case 6: {
                    this.handleVoidResult();
                    break;
                }
                case 7: {
                    this.handleVoidResult();
                    break;
                }
                default: {
                    LOG.error("Unsupported call: " + this.lastRequest);
                    break;
                }
            }
        } else {
            this.handleError(responseBytes);
        }
        ((Object)((Object)this)).notify();
    }

    private void handleGetPartitionsResult(byte[] response) {
        int offset = 1;
        int partitions = BytesUtil.bytesToInt(response, offset);
        offset += 4;
        if (partitions == 0) {
            this.getPartitionsResult = null;
        } else {
            this.getPartitionsResult = new ArrayList<Integer>();
            for (int i = 0; i < partitions; ++i) {
                int next = BytesUtil.bytesToInt(response, offset);
                offset += 4;
                this.getPartitionsResult.add(next);
            }
        }
        this.hasError = false;
    }

    private void handleWriteResult(byte[] response) {
        int result;
        int offset = 1;
        this.writeResult = result = BytesUtil.bytesToInt(response, offset);
        this.hasError = false;
    }

    private void handleVoidResult() {
        this.hasError = false;
    }

    public synchronized List<Integer> getPartitions(String tableName) throws Exception {
        this.ensureConnectionReady();
        byte[] tableNameInBytes = tableName.getBytes("UTF-8");
        int totalLength = 5 + tableNameInBytes.length;
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[][])new byte[][]{BytesUtil.intToBytes(totalLength), TableServiceMessage.GET_PARTITIONS_BYTES, tableNameInBytes});
        this.context.writeAndFlush((Object)buffer);
        this.lastRequest = 1;
        ((Object)((Object)this)).wait();
        if (this.hasError) {
            this.hasError = false;
            throw new TableServiceException(new RuntimeException(this.errorMsg));
        }
        return this.getPartitionsResult == null ? Collections.emptyList() : this.getPartitionsResult;
    }

    public synchronized void unregisterPartitions(String tableName) throws Exception {
        this.ensureConnectionReady();
        byte[] tableNameInBytes = tableName.getBytes("UTF-8");
        int totalLength = 5 + tableNameInBytes.length;
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[][])new byte[][]{BytesUtil.intToBytes(totalLength), TableServiceMessage.UNREGISTER_PARTITIONS_BYTES, tableNameInBytes});
        this.context.writeAndFlush((Object)buffer);
        this.lastRequest = (byte)6;
        ((Object)((Object)this)).wait();
        if (this.hasError) {
            this.hasError = false;
            throw new TableServiceException(new RuntimeException(this.errorMsg));
        }
    }

    public synchronized int write(String tableName, int partitionId, byte[] content) throws Exception {
        this.ensureConnectionReady();
        byte[] tableNameInBytes = tableName.getBytes("UTF-8");
        int contentLength = content == null ? 0 : content.length;
        int totalLength = 9 + tableNameInBytes.length + 4 + contentLength;
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[][])new byte[][]{BytesUtil.intToBytes(totalLength), TableServiceMessage.WRITE_BYTES, BytesUtil.intToBytes(tableNameInBytes.length), tableNameInBytes, BytesUtil.intToBytes(partitionId), content});
        this.context.writeAndFlush((Object)buffer);
        this.lastRequest = (byte)2;
        ((Object)((Object)this)).wait();
        if (this.hasError) {
            this.hasError = false;
            throw new RuntimeException(this.errorMsg);
        }
        return this.writeResult;
    }

    public synchronized void initializePartition(String tableName, int partitionId) throws Exception {
        this.sendVoidResponseRequest(tableName, partitionId, TableServiceMessage.INITIALIZE_PARTITION_BYTES, (byte)4);
    }

    public synchronized void deletePartition(String tableName, int partitionId) throws Exception {
        this.sendVoidResponseRequest(tableName, partitionId, TableServiceMessage.DELETE_PARTITION_BYTES, (byte)3);
    }

    public synchronized void registerPartition(String tableName, int partitionId) throws Exception {
        this.sendVoidResponseRequest(tableName, partitionId, TableServiceMessage.REGISTER_PARTITION_BYTES, (byte)5);
    }

    public synchronized void finishPartition(String tableName, int partitionId) throws Exception {
        this.sendVoidResponseRequest(tableName, partitionId, TableServiceMessage.FINISH_PARTITION_BYTES, (byte)7);
    }

    private void sendVoidResponseRequest(String tableName, int partitionId, byte[] messageTypeBytes, byte messageType) throws Exception {
        this.ensureConnectionReady();
        ByteBuf buffer = this.createVoidResponseRequest(tableName, partitionId, messageTypeBytes);
        this.context.writeAndFlush((Object)buffer);
        this.lastRequest = messageType;
        ((Object)((Object)this)).wait();
        if (this.hasError) {
            this.hasError = false;
            throw new RuntimeException(this.errorMsg);
        }
    }

    private ByteBuf createVoidResponseRequest(String tableName, int partitionId, byte[] messageTypeBytes) throws Exception {
        byte[] tableNameInBytes = tableName.getBytes("UTF-8");
        int totalLength = 9 + tableNameInBytes.length + 4;
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[][])new byte[][]{BytesUtil.intToBytes(totalLength), messageTypeBytes, BytesUtil.intToBytes(tableNameInBytes.length), tableNameInBytes, BytesUtil.intToBytes(partitionId)});
        return buffer;
    }

    private void handleError(byte[] response) {
        int offset = 5;
        this.hasError = true;
        try {
            this.errorMsg = new String(response, offset, response.length - offset, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            LOG.error(e2.getMessage(), (Throwable)e2);
            this.errorMsg = "Unsupported msg encoding";
        }
    }
}

