/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.temptable.util;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.util.BinaryRowUtil;
import org.apache.flink.table.typeutils.BaseRowSerializer;

public final class BytesUtil {
    private BytesUtil() {
    }

    public static int bytesToInt(byte[] bytes) {
        return BytesUtil.bytesToInt(bytes, 0);
    }

    public static int bytesToInt(byte[] bytes, int offset) {
        int ans = 0;
        ans |= (bytes[offset] & 0xFF) << 24;
        ans |= (bytes[offset + 1] & 0xFF) << 16;
        ans |= (bytes[offset + 2] & 0xFF) << 8;
        return ans |= bytes[offset + 3] & 0xFF;
    }

    public static byte[] intToBytes(int x) {
        byte[] buffer = new byte[]{(byte)(x >> 24 & 0xFF), (byte)(x >> 16 & 0xFF), (byte)(x >> 8 & 0xFF), (byte)(x & 0xFF)};
        return buffer;
    }

    public static byte[] longToBytes(long x) {
        byte[] buffer = new byte[]{(byte)(x >> 56 & 0xFFL), (byte)(x >> 48 & 0xFFL), (byte)(x >> 40 & 0xFFL), (byte)(x >> 32 & 0xFFL), (byte)(x >> 24 & 0xFFL), (byte)(x >> 16 & 0xFFL), (byte)(x >> 8 & 0xFFL), (byte)(x & 0xFFL)};
        return buffer;
    }

    public static byte[] intsToBytes(Collection<Integer> ints) {
        if (ints == null || ints.isEmpty()) {
            return new byte[0];
        }
        byte[] buffer = new byte[4 * ints.size()];
        int index = 0;
        for (Integer x : ints) {
            byte[] bytes = BytesUtil.intToBytes(x);
            System.arraycopy(bytes, 0, buffer, index * 4, 4);
        }
        return buffer;
    }

    public static byte[] serialize(BaseRow baseRow, BaseRowSerializer baseRowSerializer) {
        BinaryRow binaryRow;
        if (baseRow.getClass() == BinaryRow.class) {
            binaryRow = (BinaryRow)baseRow;
        } else {
            try {
                binaryRow = baseRowSerializer.baseRowToBinary(baseRow);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        byte[] rowBytes = BinaryRowUtil.copy(binaryRow.getAllSegments(), binaryRow.getBaseOffset(), binaryRow.getSizeInBytes());
        byte[] buffer = new byte[binaryRow.getSizeInBytes() + 4];
        byte[] intBytes = BytesUtil.intToBytes(binaryRow.getSizeInBytes());
        for (int i = 0; i < 4; ++i) {
            buffer[i] = intBytes[i];
        }
        System.arraycopy(rowBytes, 0, buffer, 4, binaryRow.getSizeInBytes());
        return buffer;
    }

    public static BaseRow deSerialize(byte[] buffer, int offset, int sizeInBytes, BaseRowSerializer baseRowSerializer) {
        MemorySegment memorySegment = MemorySegmentFactory.wrap(buffer);
        BinaryRow row2 = new BinaryRow(baseRowSerializer.getNumFields());
        row2.pointTo(memorySegment, offset, sizeInBytes);
        return row2;
    }

    public static BaseRow deSerialize(byte[] buffer, int sizeInBytes, BaseRowSerializer baseRowSerializer) {
        return BytesUtil.deSerialize(buffer, 0, sizeInBytes, baseRowSerializer);
    }
}

