/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.types.ArrayType;
import org.apache.flink.table.types.BooleanType;
import org.apache.flink.table.types.ByteArrayType;
import org.apache.flink.table.types.ByteType;
import org.apache.flink.table.types.CharType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.GenericType;
import org.apache.flink.table.types.IntType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.IntervalRangeType;
import org.apache.flink.table.types.IntervalRowsType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.MapType;
import org.apache.flink.table.types.MultisetType;
import org.apache.flink.table.types.PrimitiveType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.ShortType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimeType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.table.types.TypeInfoWrappedDataType;

public class DataTypes {
    public static final StringType STRING = StringType.INSTANCE;
    public static final BooleanType BOOLEAN = BooleanType.INSTANCE;
    public static final DoubleType DOUBLE = DoubleType.INSTANCE;
    public static final FloatType FLOAT = FloatType.INSTANCE;
    public static final ByteType BYTE = ByteType.INSTANCE;
    public static final IntType INT = IntType.INSTANCE;
    public static final LongType LONG = LongType.INSTANCE;
    public static final ShortType SHORT = ShortType.INSTANCE;
    public static final CharType CHAR = CharType.INSTANCE;
    public static final ByteArrayType BYTE_ARRAY = ByteArrayType.INSTANCE;
    public static final DateType DATE = DateType.DATE;
    public static final TimestampType TIMESTAMP = TimestampType.TIMESTAMP;
    public static final TimeType TIME = TimeType.INSTANCE;
    public static final DateType INTERVAL_MONTHS = DateType.INTERVAL_MONTHS;
    public static final TimestampType INTERVAL_MILLIS = TimestampType.INTERVAL_MILLIS;
    public static final TimestampType ROWTIME_INDICATOR = TimestampType.ROWTIME_INDICATOR;
    public static final TimestampType PROCTIME_INDICATOR = TimestampType.PROCTIME_INDICATOR;
    public static final IntervalRowsType INTERVAL_ROWS = IntervalRowsType.INSTANCE;
    public static final IntervalRangeType INTERVAL_RANGE = IntervalRangeType.INSTANCE;
    public static final List<PrimitiveType> INTEGRAL_TYPES = Arrays.asList(BYTE, SHORT, INT, LONG);
    public static final List<PrimitiveType> FRACTIONAL_TYPES = Arrays.asList(FLOAT, DOUBLE);
    public static final int ROWTIME_STREAM_MARKER = -1;
    public static final int PROCTIME_STREAM_MARKER = -2;
    public static final int ROWTIME_BATCH_MARKER = -3;
    public static final int PROCTIME_BATCH_MARKER = -4;

    public static ArrayType createArrayType(DataType elementType) {
        return new ArrayType(elementType);
    }

    public static ArrayType createPrimitiveArrayType(DataType elementType) {
        return new ArrayType(elementType, true);
    }

    public static DecimalType createDecimalType(int precision, int scale) {
        return new DecimalType(precision, scale);
    }

    public static MapType createMapType(DataType keyType, DataType valueType) {
        return new MapType(keyType, valueType);
    }

    public static <T> GenericType<T> createGenericType(Class<T> cls) {
        return new GenericType<T>(cls);
    }

    public static <T> GenericType<T> createGenericType(TypeInformation<T> typeInfo) {
        return new GenericType<T>(typeInfo);
    }

    public static MultisetType createMultisetType(DataType elementType) {
        return new MultisetType(elementType);
    }

    @Deprecated
    public static DataType createRowType(DataType[] types, String[] fieldNames) {
        return new RowType(types, fieldNames);
    }

    public static RowType createRowTypeV2(DataType[] types, String[] fieldNames) {
        return new RowType(types, fieldNames);
    }

    @Deprecated
    public static DataType createRowType(InternalType[] types, String[] fieldNames) {
        return new RowType((DataType[])types, fieldNames);
    }

    public static RowType createRowTypeV2(InternalType[] types, String[] fieldNames) {
        return new RowType((DataType[])types, fieldNames);
    }

    @Deprecated
    public static DataType createRowType(DataType ... types) {
        return new RowType(types);
    }

    public static RowType createRowTypeV2(DataType ... types) {
        return new RowType(types);
    }

    public static RowType createRowType(InternalType ... types) {
        return new RowType((DataType[])types);
    }

    public static <T extends Tuple> DataType createTupleType(Class<T> cls, DataType ... types) {
        TupleTypeInfo<T> typeInfo = new TupleTypeInfo<T>(cls, TypeConverters.createExternalTypeInfoFromDataTypes(types));
        return new TypeInfoWrappedDataType(typeInfo);
    }

    public static DataType createTupleType(DataType ... types) {
        TupleTypeInfo typeInfo = new TupleTypeInfo(TypeConverters.createExternalTypeInfoFromDataTypes(types));
        return new TypeInfoWrappedDataType(typeInfo);
    }

    public static <T> PojoBuilder pojoBuilder(Class<T> typeClass) {
        return new PojoBuilder(typeClass);
    }

    public static DataType extractDataType(Class<?> cls) {
        return new TypeInfoWrappedDataType(TypeExtractor.createTypeInfo(cls));
    }

    public static TypeSerializer createExternalSerializer(DataType type) {
        return TypeConverters.createExternalTypeInfoFromDataType(type).createSerializer(new ExecutionConfig());
    }

    public static TypeSerializer createInternalSerializer(DataType type) {
        return TypeConverters.createInternalTypeInfoFromDataType(type).createSerializer(new ExecutionConfig());
    }

    public static class PojoBuilder<T> {
        private Class<T> typeClass;
        private List<PojoField> fields;

        private PojoBuilder(Class<T> typeClass) {
            this.typeClass = typeClass;
            this.fields = new ArrayList<PojoField>();
        }

        public PojoBuilder field(String name, DataType type) throws NoSuchFieldException {
            this.fields.add(new PojoField(this.typeClass.getDeclaredField(name), TypeConverters.createExternalTypeInfoFromDataType(type)));
            return this;
        }

        public TypeInfoWrappedDataType build() {
            PojoTypeInfo<T> typeInfo = new PojoTypeInfo<T>(this.typeClass, this.fields);
            return new TypeInfoWrappedDataType(typeInfo);
        }
    }
}

