/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.typeutils.BaseArraySerializer;

public class BaseArrayTypeInfo
extends TypeInformation<BaseArray> {
    private static final long serialVersionUID = 1L;
    private final boolean isPrimitive;
    private final DataType eleType;

    public BaseArrayTypeInfo(boolean isPrimitive, DataType eleType) {
        this.isPrimitive = isPrimitive;
        this.eleType = eleType;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public DataType getEleType() {
        return this.eleType;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<BaseArray> getTypeClass() {
        return BaseArray.class;
    }

    @Override
    public boolean isKeyType() {
        return false;
    }

    @Override
    public TypeSerializer<BaseArray> createSerializer(ExecutionConfig executionConfig) {
        return new BaseArraySerializer(this.isPrimitive, this.eleType.toInternalType());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.eleType.toInternalType() + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BaseArrayTypeInfo) {
            BaseArrayTypeInfo typeInfo = (BaseArrayTypeInfo)obj;
            return typeInfo.canEqual(this) && this.isPrimitive == typeInfo.isPrimitive && this.eleType.toInternalType().equals(typeInfo.eleType.toInternalType());
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BaseArrayTypeInfo;
    }

    @Override
    public int hashCode() {
        return 31 * Boolean.hashCode(this.isPrimitive) + this.eleType.toInternalType().hashCode();
    }
}

