/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.typeutils.DecimalSerializer;

@Internal
public final class DecimalComparator
extends BasicTypeComparator<Decimal> {
    private static final long serialVersionUID = 1L;
    final DecimalSerializer serializer;
    private int precision;
    private int scale;

    public DecimalComparator(boolean ascending, int precision, int scale) {
        super(ascending);
        this.serializer = new DecimalSerializer(precision, scale);
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        Decimal d1 = this.serializer.deserialize(firstSource);
        Decimal d2 = this.serializer.deserialize(secondSource);
        int comp = d1.compareTo(d2);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return this.precision <= 18;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 8;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 8;
    }

    @Override
    public void putNormalizedKey(Decimal record, MemorySegment target, int offset, int len) {
        throw new RuntimeException("please use codeGen!");
    }

    public DecimalComparator duplicate() {
        return new DecimalComparator(this.ascendingComparison, this.serializer.precision, this.serializer.scale);
    }
}

