/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.util.Arrays;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.typeutils.DecimalSerializer;

public class DecimalTypeInfo
extends TypeInformation<Decimal> {
    private final int precision;
    private final int scale;

    public static DecimalTypeInfo of(int precision, int scale) {
        return new DecimalTypeInfo(precision, scale);
    }

    public DecimalTypeInfo(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public boolean isBasicType() {
        return true;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<Decimal> getTypeClass() {
        return Decimal.class;
    }

    @Override
    public boolean isKeyType() {
        return true;
    }

    @Override
    public TypeSerializer<Decimal> createSerializer(ExecutionConfig config) {
        return DecimalSerializer.of(this.precision, this.scale);
    }

    @Override
    public String toString() {
        return String.format("Decimal(%d,%d)", this.precision, this.scale);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DecimalTypeInfo)) {
            return false;
        }
        DecimalTypeInfo that = (DecimalTypeInfo)obj;
        return this.precision == that.precision && this.scale == that.scale;
    }

    @Override
    public int hashCode() {
        int h0 = this.getClass().getCanonicalName().hashCode();
        return Arrays.hashCode(new int[]{h0, this.precision, this.scale});
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof DecimalTypeInfo;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }
}

