/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.math.BigInteger;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.BigIntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.typeutils.BinaryStringSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedBigIntSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedBinaryStringSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedBooleanSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedByteSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedCharSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedDoubleSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedFloatSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedFractionalTypeInfo;
import org.apache.flink.table.typeutils.ordered.OrderedIntSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedIntegerTypeInfo;
import org.apache.flink.table.typeutils.ordered.OrderedLongSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedShortSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedStringSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public class OrderedBasicTypeInfo<T>
extends TypeInformation<T> {
    private static final long serialVersionUID = -430955220409131770L;
    public static final OrderedBasicTypeInfo<String> ASC_STRING_TYPE_INFO = new OrderedBasicTypeInfo<String>(String.class, OrderedStringSerializer.ASC_INSTANCE, StringSerializer.INSTANCE);
    public static final OrderedBasicTypeInfo<String> DESC_STRING_TYPE_INFO = new OrderedBasicTypeInfo<String>(String.class, OrderedStringSerializer.DESC_INSTANCE, StringSerializer.INSTANCE);
    public static final OrderedBasicTypeInfo<Boolean> ASC_BOOLEAN_TYPE_INFO = new OrderedBasicTypeInfo<Boolean>(Boolean.class, OrderedBooleanSerializer.ASC_INSTANCE);
    public static final OrderedBasicTypeInfo<Boolean> DESC_BOOLEAN_TYPE_INFO = new OrderedBasicTypeInfo<Boolean>(Boolean.class, OrderedBooleanSerializer.DESC_INSTANCE);
    public static final OrderedBasicTypeInfo<Byte> ASC_BYTE_TYPE_INFO = new OrderedIntegerTypeInfo<Byte>(Byte.class, OrderedByteSerializer.ASC_INSTANCE);
    public static final OrderedBasicTypeInfo<Byte> DESC_BYTE_TYPE_INFO = new OrderedIntegerTypeInfo<Byte>(Byte.class, OrderedByteSerializer.DESC_INSTANCE);
    public static final OrderedBasicTypeInfo<Short> ASC_SHORT_TYPE_INFO = new OrderedIntegerTypeInfo<Short>(Short.class, OrderedShortSerializer.ASC_INSTANCE);
    public static final OrderedBasicTypeInfo<Short> DESC_SHORT_TYPE_INFO = new OrderedIntegerTypeInfo<Short>(Short.class, OrderedShortSerializer.DESC_INSTANCE);
    public static final OrderedBasicTypeInfo<Integer> ASC_INT_TYPE_INFO = new OrderedIntegerTypeInfo<Integer>(Integer.class, OrderedIntSerializer.ASC_INSTANCE);
    public static final OrderedBasicTypeInfo<Integer> DESC_INT_TYPE_INFO = new OrderedIntegerTypeInfo<Integer>(Integer.class, OrderedIntSerializer.DESC_INSTANCE);
    public static final OrderedBasicTypeInfo<Long> ASC_LONG_TYPE_INFO = new OrderedIntegerTypeInfo<Long>(Long.class, OrderedLongSerializer.ASC_INSTANCE);
    public static final OrderedBasicTypeInfo<Long> DESC_LONG_TYPE_INFO = new OrderedIntegerTypeInfo<Long>(Long.class, OrderedLongSerializer.DESC_INSTANCE);
    public static final OrderedBasicTypeInfo<Float> ASC_FLOAT_TYPE_INFO = new OrderedFractionalTypeInfo<Float>(Float.class, OrderedFloatSerializer.ASC_INSTANCE);
    public static final OrderedBasicTypeInfo<Float> DESC_FLOAT_TYPE_INFO = new OrderedFractionalTypeInfo<Float>(Float.class, OrderedFloatSerializer.DESC_INSTANCE);
    public static final OrderedBasicTypeInfo<Double> ASC_DOUBLE_TYPE_INFO = new OrderedFractionalTypeInfo<Double>(Double.class, OrderedDoubleSerializer.ASC_INSTANCE);
    public static final OrderedBasicTypeInfo<Double> DESC_DOUBLE_TYPE_INFO = new OrderedFractionalTypeInfo<Double>(Double.class, OrderedDoubleSerializer.DESC_INSTANCE);
    public static final OrderedBasicTypeInfo<Character> ASC_CHAR_TYPE_INFO = new OrderedBasicTypeInfo<Character>(Character.class, OrderedCharSerializer.ASC_INSTANCE);
    public static final OrderedBasicTypeInfo<Character> DESC_CHAR_TYPE_INFO = new OrderedBasicTypeInfo<Character>(Character.class, OrderedCharSerializer.DESC_INSTANCE);
    public static final OrderedBasicTypeInfo<BigInteger> ASC_BIG_INT_TYPE_INFO = new OrderedBasicTypeInfo<BigInteger>(BigInteger.class, OrderedBigIntSerializer.ASC_INSTANCE, BigIntSerializer.INSTANCE);
    public static final OrderedBasicTypeInfo<BigInteger> DESC_BIG_INT_TYPE_INFO = new OrderedBasicTypeInfo<BigInteger>(BigInteger.class, OrderedBigIntSerializer.DESC_INSTANCE, BigIntSerializer.INSTANCE);
    public static final OrderedBasicTypeInfo<BinaryString> ASC_BINARY_STRING_TYPE_INFO = new OrderedBasicTypeInfo<BinaryString>(BinaryString.class, OrderedBinaryStringSerializer.ASC_INSTANCE, BinaryStringSerializer.INSTANCE);
    public static final OrderedBasicTypeInfo<BinaryString> DESC_BINARY_STRING_TYPE_INFO = new OrderedBasicTypeInfo<BinaryString>(BinaryString.class, OrderedBinaryStringSerializer.DESC_INSTANCE, BinaryStringSerializer.INSTANCE);
    private final Class<T> clazz;
    private final TypeSerializer<T> serializer;
    private final TypeSerializer<T> heapSerializer;

    protected OrderedBasicTypeInfo(Class<T> clazz, TypeSerializer<T> serializer) {
        this.clazz = Preconditions.checkNotNull(clazz);
        this.serializer = Preconditions.checkNotNull(serializer);
        this.heapSerializer = null;
    }

    protected OrderedBasicTypeInfo(Class<T> clazz, TypeSerializer<T> serializer, TypeSerializer<T> heapSerializer) {
        this.clazz = Preconditions.checkNotNull(clazz);
        this.serializer = Preconditions.checkNotNull(serializer);
        this.heapSerializer = Preconditions.checkNotNull(heapSerializer);
    }

    @Override
    public boolean isBasicType() {
        return true;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.clazz;
    }

    @Override
    public boolean isKeyType() {
        return true;
    }

    @Override
    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        if (config.getGlobalJobParameters() != null) {
            Configuration parameters = new Configuration();
            parameters.addAll(config.getGlobalJobParameters().toMap());
            if (parameters.getBoolean("statebackend.onheap", true) && this.heapSerializer != null) {
                return this.heapSerializer;
            }
        }
        return this.serializer;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clazz, this.serializer);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedBasicTypeInfo;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OrderedBasicTypeInfo) {
            OrderedBasicTypeInfo other = (OrderedBasicTypeInfo)obj;
            return other.canEqual(this) && this.clazz == other.clazz && this.serializer.equals(other.serializer);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.clazz.getSimpleName();
    }
}

