/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BigDecSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedBasicTypeInfo;
import org.apache.flink.table.typeutils.ordered.OrderedBigDecSerializer;

@Internal
public class OrderedBigDecTypeInfo
extends OrderedBasicTypeInfo<BigDecimal> {
    private static final long serialVersionUID = 1L;
    private final int precision;
    private final int scale;
    private final boolean asc;

    public static OrderedBigDecTypeInfo of(int precision, int scale, boolean asc) {
        return new OrderedBigDecTypeInfo(precision, scale, asc);
    }

    public static OrderedBigDecTypeInfo of(BigDecimal value, boolean asc) {
        return OrderedBigDecTypeInfo.of(value.precision(), value.scale(), asc);
    }

    public OrderedBigDecTypeInfo(int precision, int scale, boolean asc) {
        super(BigDecimal.class, asc ? OrderedBigDecSerializer.ASC_INSTANCE : OrderedBigDecSerializer.DESC_INSTANCE, BigDecSerializer.INSTANCE);
        this.precision = precision;
        this.scale = scale;
        this.asc = asc;
    }

    @Override
    public String toString() {
        return String.format("Decimal(%d,%d)", this.precision(), this.scale());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OrderedBigDecTypeInfo)) {
            return false;
        }
        OrderedBigDecTypeInfo that = (OrderedBigDecTypeInfo)obj;
        return this.precision() == that.precision() && this.scale() == that.scale() && this.asc == that.asc;
    }

    @Override
    public int hashCode() {
        int h0 = this.getClass().getCanonicalName().hashCode();
        return Arrays.hashCode(new int[]{h0, this.precision(), this.scale(), this.asc ? 0 : 1});
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }
}

