/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedCharSerializer
extends TypeSerializerSingleton<Character> {
    private static final long serialVersionUID = 1L;
    public static final OrderedCharSerializer ASC_INSTANCE = new OrderedCharSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedCharSerializer DESC_INSTANCE = new OrderedCharSerializer(OrderedBytes.Order.DESCENDING);
    private static final Character ZERO = Character.valueOf('\u0000');
    private static final OrderedBytes orderedBytes = new OrderedBytes();
    private final OrderedBytes.Order ord;

    private OrderedCharSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Character createInstance() {
        return ZERO;
    }

    @Override
    public Character copy(Character from) {
        return from;
    }

    @Override
    public Character copy(Character from, Character reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public void serialize(Character record, DataOutputView target) throws IOException {
        orderedBytes.encodeChar(target, record.charValue(), this.ord);
    }

    @Override
    public Character deserialize(DataInputView source) throws IOException {
        return Character.valueOf(orderedBytes.decodeChar(source, this.ord));
    }

    @Override
    public Character deserialize(Character reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        orderedBytes.encodeChar(target, orderedBytes.decodeChar(source, this.ord), this.ord);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedCharSerializer;
    }
}

