/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.typeutils.DecimalSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedBasicTypeInfo;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;
import org.apache.flink.table.typeutils.ordered.OrderedDecimalSerializer;

@Internal
public class OrderedDecTypeInfo
extends OrderedBasicTypeInfo<Decimal> {
    private static final long serialVersionUID = 1L;
    private final int precision;
    private final int scale;
    private final boolean asc;

    public static OrderedDecTypeInfo of(int precision, int scale, boolean asc) {
        return new OrderedDecTypeInfo(precision, scale, asc);
    }

    public OrderedDecTypeInfo(int precision, int scale, boolean asc) {
        super(Decimal.class, new OrderedDecimalSerializer(precision, scale, asc ? OrderedBytes.Order.ASCENDING : OrderedBytes.Order.DESCENDING), new DecimalSerializer(precision, scale));
        this.precision = precision;
        this.scale = scale;
        this.asc = asc;
    }

    @Override
    public String toString() {
        return String.format("Decimal(%d,%d)", this.precision(), this.scale());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OrderedDecTypeInfo)) {
            return false;
        }
        OrderedDecTypeInfo that = (OrderedDecTypeInfo)obj;
        return this.precision() == that.precision() && this.scale() == that.scale() && this.asc == that.asc;
    }

    @Override
    public int hashCode() {
        int h0 = this.getClass().getCanonicalName().hashCode();
        return Arrays.hashCode(new int[]{h0, this.precision(), this.scale(), this.asc ? 0 : 1});
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }
}

