/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.ParameterlessTypeSerializerConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedDecimalSerializer
extends TypeSerializer<Decimal> {
    private static final long serialVersionUID = 1L;
    private final int precision;
    private final int scale;
    private final OrderedBytes orderedBytes;
    private final OrderedBytes.Order ord;
    private String serializationFormatIdentifier;

    public static OrderedDecimalSerializer of(int precision, int scale, OrderedBytes.Order ord) {
        return new OrderedDecimalSerializer(precision, scale, ord);
    }

    public OrderedDecimalSerializer(int precision, int scale, OrderedBytes.Order ord) {
        this.precision = precision;
        this.scale = scale;
        this.orderedBytes = new OrderedBytes();
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public Decimal createInstance() {
        return Decimal.zero(this.precision, this.scale);
    }

    @Override
    public Decimal copy(Decimal from) {
        return from.copy();
    }

    @Override
    public Decimal copy(Decimal from, Decimal reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(Decimal record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        this.orderedBytes.encodeDecimal(target, record, this.ord);
    }

    @Override
    public Decimal deserialize(DataInputView source) throws IOException {
        return this.orderedBytes.decodeDecimal(source, this.precision, this.scale, this.ord);
    }

    @Override
    public Decimal deserialize(Decimal record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.orderedBytes.encodeDecimal(target, this.orderedBytes.decodeDecimal(source, this.precision, this.scale, this.ord), this.ord);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedDecimalSerializer;
    }

    public OrderedDecimalSerializer duplicate() {
        return new OrderedDecimalSerializer(this.precision, this.scale, this.ord);
    }

    @Override
    public int hashCode() {
        return this.getSerializationFormatIdentifier().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OrderedDecimalSerializer)) {
            return false;
        }
        OrderedDecimalSerializer that = (OrderedDecimalSerializer)obj;
        return this.precision == that.precision && this.scale == that.scale;
    }

    private String getSerializationFormatIdentifier() {
        String id = this.serializationFormatIdentifier;
        if (id == null) {
            this.serializationFormatIdentifier = id = this.getClass().getCanonicalName() + "," + this.precision + "," + this.scale;
        }
        return id;
    }

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new ParameterlessTypeSerializerConfig(this.getSerializationFormatIdentifier());
    }

    @Override
    public CompatibilityResult<Decimal> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof ParameterlessTypeSerializerConfig && this.isCompatibleSerializationFormatIdentifier(((ParameterlessTypeSerializerConfig)configSnapshot).getSerializationFormatIdentifier())) {
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    private boolean isCompatibleSerializationFormatIdentifier(String identifier) {
        return identifier.equals(this.getSerializationFormatIdentifier());
    }
}

