/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedDoubleSerializer
extends TypeSerializerSingleton<Double> {
    private static final long serialVersionUID = 1L;
    public static final OrderedDoubleSerializer ASC_INSTANCE = new OrderedDoubleSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedDoubleSerializer DESC_INSTANCE = new OrderedDoubleSerializer(OrderedBytes.Order.DESCENDING);
    private static final Double ZERO = 0.0;
    private static final OrderedBytes orderedBytes = new OrderedBytes();
    private final OrderedBytes.Order ord;

    private OrderedDoubleSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Double createInstance() {
        return ZERO;
    }

    @Override
    public Double copy(Double from) {
        return from;
    }

    @Override
    public Double copy(Double from, Double reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void serialize(Double record, DataOutputView target) throws IOException {
        orderedBytes.encodeDouble(target, record, this.ord);
    }

    @Override
    public Double deserialize(DataInputView source) throws IOException {
        return orderedBytes.decodeDouble(source, this.ord);
    }

    @Override
    public Double deserialize(Double reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        orderedBytes.encodeDouble(target, orderedBytes.decodeDouble(source, this.ord), this.ord);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedDoubleSerializer;
    }
}

