/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedNumericTypeInfo;
import org.apache.flink.util.Preconditions;

@Internal
public class OrderedIntegerTypeInfo<T>
extends OrderedNumericTypeInfo<T> {
    private static final long serialVersionUID = -8068827354966766955L;
    private static final HashSet<Class<?>> integerTypes = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Byte.class, Short.class, Character.class));

    protected OrderedIntegerTypeInfo(Class<T> clazz, TypeSerializer<T> serializer) {
        super(clazz, serializer);
        Preconditions.checkArgument(integerTypes.contains(clazz), "The given class %s is not a integer type.", clazz.getSimpleName());
    }
}

