/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedBasicTypeInfo;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class OrderedNumericTypeInfo<T>
extends OrderedBasicTypeInfo<T> {
    private static final long serialVersionUID = -5937777910658986986L;
    private static final HashSet<Class<?>> numericalTypes = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Double.class, Byte.class, Short.class, Float.class, Character.class));

    protected OrderedNumericTypeInfo(Class<T> clazz, TypeSerializer<T> serializer) {
        super(clazz, serializer);
        Preconditions.checkArgument(numericalTypes.contains(clazz), "The given class %s is not a numerical type", clazz.getSimpleName());
    }
}

