/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.table.typeutils.ordered.OrderedBytePrimitiveArraySerializer;
import org.apache.flink.util.Preconditions;

@Internal
public class OrderedPrimitiveArrayTypeInfo<T>
extends TypeInformation<T> {
    private static final long serialVersionUID = 1L;
    public static final OrderedPrimitiveArrayTypeInfo<byte[]> ASC_BYTE_PRIMITIVE_ARRAY_TYPE_INFO = new OrderedPrimitiveArrayTypeInfo<byte[]>(byte[].class, OrderedBytePrimitiveArraySerializer.ASC_INSTANCE, BytePrimitiveArraySerializer.INSTANCE);
    public static final OrderedPrimitiveArrayTypeInfo<byte[]> DESC_BYTE_PRIMITIVE_ARRAY_TYPE_INFO = new OrderedPrimitiveArrayTypeInfo<byte[]>(byte[].class, OrderedBytePrimitiveArraySerializer.DESC_INSTANCE, BytePrimitiveArraySerializer.INSTANCE);
    private final Class<T> arrayClass;
    private final TypeSerializer<T> serializer;
    private final TypeSerializer<T> heapSerializer;

    private OrderedPrimitiveArrayTypeInfo(Class<T> arrayClass, TypeSerializer<T> serializer, TypeSerializer<T> heapSerializer) {
        this.arrayClass = Preconditions.checkNotNull(arrayClass);
        this.serializer = Preconditions.checkNotNull(serializer);
        this.heapSerializer = Preconditions.checkNotNull(heapSerializer);
        Preconditions.checkArgument(arrayClass.isArray() && arrayClass.getComponentType().isPrimitive(), "Class must represent an array of primitives");
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.arrayClass;
    }

    @Override
    public boolean isKeyType() {
        return true;
    }

    @Override
    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        return this.serializer;
    }

    @Override
    public String toString() {
        return this.arrayClass.getComponentType().getName() + "[]";
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof OrderedPrimitiveArrayTypeInfo) {
            OrderedPrimitiveArrayTypeInfo otherArray = (OrderedPrimitiveArrayTypeInfo)other;
            return otherArray.canEqual(this) && this.arrayClass == otherArray.arrayClass && this.serializer.equals(otherArray.serializer);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arrayClass, this.serializer);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedPrimitiveArrayTypeInfo;
    }
}

