/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.ParameterlessTypeSerializerConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedStringSerializer
extends TypeSerializer<String> {
    private static final long serialVersionUID = 1L;
    public static final OrderedStringSerializer ASC_INSTANCE = new OrderedStringSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedStringSerializer DESC_INSTANCE = new OrderedStringSerializer(OrderedBytes.Order.DESCENDING);
    private static final String EMPTY = "";
    private final OrderedBytes orderedBytes;
    private final OrderedBytes.Order ord;
    private String serializationFormatIdentifier;

    private OrderedStringSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
        this.orderedBytes = new OrderedBytes();
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public TypeSerializer<String> duplicate() {
        return new OrderedStringSerializer(this.ord);
    }

    @Override
    public String createInstance() {
        return EMPTY;
    }

    @Override
    public String copy(String from) {
        return from;
    }

    @Override
    public String copy(String from, String reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(String record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        this.orderedBytes.encodeString(target, record, this.ord);
    }

    @Override
    public String deserialize(DataInputView source) throws IOException {
        return this.orderedBytes.decodeString(source, this.ord);
    }

    @Override
    public String deserialize(String record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.orderedBytes.encodeString(target, this.orderedBytes.decodeString(source, this.ord), this.ord);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.canEqual(obj)) {
            OrderedStringSerializer other = (OrderedStringSerializer)obj;
            return this.ord.equals((Object)other.ord);
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedStringSerializer;
    }

    @Override
    public int hashCode() {
        return this.getSerializationFormatIdentifier().hashCode();
    }

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new ParameterlessTypeSerializerConfig(this.getSerializationFormatIdentifier());
    }

    @Override
    public CompatibilityResult<String> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof ParameterlessTypeSerializerConfig && this.isCompatibleSerializationFormatIdentifier(((ParameterlessTypeSerializerConfig)configSnapshot).getSerializationFormatIdentifier())) {
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    private String getSerializationFormatIdentifier() {
        String id = this.serializationFormatIdentifier;
        if (id == null) {
            this.serializationFormatIdentifier = id = this.getClass().getCanonicalName() + "," + (Object)((Object)this.ord);
        }
        return id;
    }

    private boolean isCompatibleSerializationFormatIdentifier(String identifier) {
        return identifier.equals(this.getSerializationFormatIdentifier());
    }
}

