/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;

public final class DescribeTableColumn$
implements Logging {
    public static final DescribeTableColumn$ MODULE$;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    static {
        new DescribeTableColumn$();
    }

    private Logger LOG$lzycompute() {
        DescribeTableColumn$ describeTableColumn$ = this;
        synchronized (describeTableColumn$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    public List<Row> describeTable(TableEnvironment tableEnv, String[] tablePath, boolean isRich) {
        BoxedUnit boxedUnit;
        String tableName = Predef$.MODULE$.refArrayOps((Object[])tablePath).mkString(".");
        Option<Table> tableOpt = tableEnv.getTable(tablePath);
        if (tableOpt.isEmpty()) {
            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table '", "' was not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
        }
        Table table = (Table)tableOpt.get();
        ArrayBuffer data = new ArrayBuffer();
        RelDataType rowType = table.getRowType(tableEnv.getTypeFactory());
        JavaConversions$.MODULE$.asScalaBuffer(rowType.getFieldList()).foreach((Function1)new Serializable(data){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer data$1;

            public final ArrayBuffer<Row> apply(RelDataTypeField f) {
                return this.data$1.$plus$eq((Object)Row.of(f.getName(), f.getType().getSqlTypeName().name(), f.getType().isNullable() ? "YES" : "NO"));
            }
            {
                this.data$1 = data$1;
            }
        });
        if (isRich) {
            data.$plus$eq((Object)Row.of("", "", ""));
            data.$plus$eq((Object)Row.of("# Detailed Table Information", "", ""));
            data.$plus$eq((Object)Row.of("table_name", tableName, ""));
            Option tableStats2 = Option$.MODULE$.apply((Object)tableEnv.getTableStats(tablePath));
            boxedUnit = data.$plus$eq((Object)Row.of("row_count", tableStats2.flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply(TableStats ts) {
                    return Option$.MODULE$.apply((Object)ts.rowCount()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Long x$1) {
                            return x$1.toString();
                        }
                    });
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "NULL";
                }
            }), ""));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return JavaConversions$.MODULE$.seqAsJavaList((Seq)data.toList());
    }

    public List<Row> describeColumn(TableEnvironment tableEnv, String[] tablePath, String column, boolean isRich) {
        String tableName = Predef$.MODULE$.refArrayOps((Object[])tablePath).mkString(".");
        Option<Table> tableOpt = tableEnv.getTable(tablePath);
        if (tableOpt.isEmpty()) {
            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table '", "' was not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
        }
        Table table = (Table)tableOpt.get();
        ArrayBuffer data = new ArrayBuffer();
        Option field = JavaConversions$.MODULE$.asScalaBuffer(table.getRowType(tableEnv.getTypeFactory()).getFieldList()).find((Function1)new Serializable(column){
            public static final long serialVersionUID = 0L;
            private final String column$1;

            public final boolean apply(RelDataTypeField x$2) {
                return x$2.getName().equalsIgnoreCase(this.column$1);
            }
            {
                this.column$1 = column$1;
            }
        });
        Option option = field;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            RelDataTypeField f = (RelDataTypeField)some.x();
            data.$plus$eq((Object)Row.of("column_name", f.getName()));
            data.$plus$eq((Object)Row.of("column_type", f.getType().getSqlTypeName().name()));
            ArrayBuffer arrayBuffer = data.$plus$eq((Object)Row.of("is_nullable", f.getType().isNullable() ? "YES" : "NO"));
            if (isRich) {
                Option columnStats = Option$.MODULE$.apply((Object)tableEnv.getTableStats(tablePath)).flatMap((Function1)new Serializable(column){
                    public static final long serialVersionUID = 0L;
                    private final String column$1;

                    public final Option<ColumnStats> apply(TableStats ts) {
                        return Option$.MODULE$.apply((Object)ts.colStats().get(this.column$1));
                    }
                    {
                        this.column$1 = column$1;
                    }
                });
                data.$plus$eq((Object)Row.of("ndv", columnStats.flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(ColumnStats cs) {
                        return Option$.MODULE$.apply((Object)cs.ndv()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Long x$3) {
                                return x$3.toString();
                            }
                        });
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "NULL";
                    }
                })));
                data.$plus$eq((Object)Row.of("null_count", columnStats.flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(ColumnStats cs) {
                        return Option$.MODULE$.apply((Object)cs.nullCount()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Long x$4) {
                                return x$4.toString();
                            }
                        });
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "NULL";
                    }
                })));
                data.$plus$eq((Object)Row.of("avg_len", columnStats.flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(ColumnStats cs) {
                        return Option$.MODULE$.apply((Object)cs.avgLen()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Double x$5) {
                                return x$5.toString();
                            }
                        });
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "NULL";
                    }
                })));
                data.$plus$eq((Object)Row.of("max_len", columnStats.flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(ColumnStats cs) {
                        return Option$.MODULE$.apply((Object)cs.maxLen()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Integer x$6) {
                                return x$6.toString();
                            }
                        });
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "NULL";
                    }
                })));
                data.$plus$eq((Object)Row.of("max", columnStats.flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(ColumnStats cs) {
                        return Option$.MODULE$.apply(cs.max()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Object x$7) {
                                return x$7.toString();
                            }
                        });
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "NULL";
                    }
                })));
                boxedUnit = data.$plus$eq((Object)Row.of("min", columnStats.flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(ColumnStats cs) {
                        return Option$.MODULE$.apply(cs.min()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Object x$8) {
                                return x$8.toString();
                            }
                        });
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "NULL";
                    }
                })));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return JavaConversions$.MODULE$.seqAsJavaList((Seq)data.toList());
        }
        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " was not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{column})));
    }

    private DescribeTableColumn$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

