/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.RichTableSchema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableProperties
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(TableProperties.class);
    public static final String TABLE_NAME = "__tablename__".toLowerCase();
    public static final String BLINK_ENVIRONMENT_TYPE_KEY = "blinkEnvironmentTypeKey".toLowerCase();
    public static final String BLINK_ENVIRONMENT_STREAM_VALUE = "stream".toLowerCase();
    public static final String BLINK_ENVIRONMENT_BATCHEXEC_VALUE = "batchExec".toLowerCase();
    public static final String BLINK_CONNECTOR_TYPE_KEY = "type".toLowerCase();
    private static final String BLINK_TABLE_SCHEMA_KEY = "__schema__";
    private static final String BLINK_TABLE_STATS_KEY = "__statistics__";
    private static final String BLINK_COMPUTED_COLUMNS_SQL_KEY = "__computedcolumnssql__";
    private static final String BLINK_ROWTIME_FIELD_KEY = "__rowtimefield__";
    private static final String BLINK_WATERMARK_OFFSET_KEY = "__watermarkoffset__";
    private static final String BLINK_TABLE_COMMENT_KEY = "__comment__";
    public static final List<String> INTERNAL_KEYS = Arrays.asList(TABLE_NAME, BLINK_ENVIRONMENT_TYPE_KEY, BLINK_ENVIRONMENT_STREAM_VALUE, BLINK_ENVIRONMENT_BATCHEXEC_VALUE, BLINK_CONNECTOR_TYPE_KEY, "__schema__", "__statistics__", "__computedcolumnssql__", "__rowtimefield__", "__watermarkoffset__", "__comment__", SchemaValidator.SCHEMA());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableProperties toKeyLowerCase() {
        TableProperties ret = new TableProperties();
        HashMap hashMap = this.confData;
        synchronized (hashMap) {
            for (Map.Entry entry : this.confData.entrySet()) {
                ret.setString(((String)entry.getKey()).toLowerCase(), entry.getValue().toString());
            }
            return ret;
        }
    }

    public TableProperties putProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.setString(property.getKey(), property.getValue());
        }
        return this;
    }

    public TableProperties property(String key, String value) {
        this.setString(key, value);
        return this;
    }

    public void putSchemaIntoProperties(RichTableSchema schema2) {
        try {
            byte[] serialized = InstantiationUtil.serializeObject(schema2);
            String encoded = Base64.getEncoder().encodeToString(serialized);
            this.setString(SchemaValidator.SCHEMA(), encoded);
        }
        catch (IOException ioe) {
            LOG.error("Exception when put rich table schema to configuration: {}", ioe.getCause());
            throw new RuntimeException(ioe.getMessage());
        }
    }

    public RichTableSchema readSchemaFromProperties(ClassLoader classLoader) {
        try {
            String encoded = this.getString(SchemaValidator.SCHEMA(), null);
            return (RichTableSchema)InstantiationUtil.deserializeObject(Base64.getDecoder().decode(encoded), classLoader);
        }
        catch (IOException | ClassNotFoundException cne) {
            LOG.error("Exception when put rich table schema to configuration: {}", cne.getCause());
            throw new RuntimeException(cne.getMessage());
        }
    }

    public void putTableSchemaIntoProperties(TableSchema schema2) {
        try {
            byte[] serialized = InstantiationUtil.serializeObject(schema2);
            String encoded = Base64.getEncoder().encodeToString(serialized);
            this.setString(BLINK_TABLE_SCHEMA_KEY, encoded);
        }
        catch (IOException ioe) {
            LOG.error("Exception when put table schema to configuration: {}", ioe.getCause());
            throw new RuntimeException(ioe.getMessage());
        }
    }

    public TableSchema readTableSchemaFromProperties(ClassLoader classLoader) {
        try {
            String encoded = this.getString(BLINK_TABLE_SCHEMA_KEY, null);
            return (TableSchema)InstantiationUtil.deserializeObject(Base64.getDecoder().decode(encoded), classLoader);
        }
        catch (IOException | ClassNotFoundException cne) {
            LOG.error("Exception when read table schema to configuration: {}", cne.getCause());
            throw new RuntimeException(cne.getMessage());
        }
    }

    public void putTableStatsIntoProperties(TableStats stats) {
        try {
            byte[] serialized = InstantiationUtil.serializeObject(stats);
            String encoded = Base64.getEncoder().encodeToString(serialized);
            this.setString(BLINK_TABLE_STATS_KEY, encoded);
        }
        catch (IOException ioe) {
            LOG.error("Exception when put table statistics to configuration: {}", ioe.getCause());
            throw new RuntimeException(ioe.getMessage());
        }
    }

    public TableStats readTableStatsFromProperties(ClassLoader classLoader) {
        try {
            String encoded = this.getString(BLINK_TABLE_STATS_KEY, null);
            return (TableStats)InstantiationUtil.deserializeObject(Base64.getDecoder().decode(encoded), classLoader);
        }
        catch (IOException | ClassNotFoundException cne) {
            LOG.error("Exception when read table statistics to configuration: {}", cne.getCause());
            throw new RuntimeException(cne.getMessage());
        }
    }

    public void putTableNameIntoProperties(String tableName) {
        Preconditions.checkArgument(tableName != null);
        this.setString(TABLE_NAME, tableName);
    }

    public String readTableNameFromProperties() {
        return this.getString(TABLE_NAME, null);
    }

    public void putComputedColumnsSql(String sql) {
        Preconditions.checkArgument(sql != null);
        this.setString(BLINK_COMPUTED_COLUMNS_SQL_KEY, sql);
    }

    public String readComputedColumnsSql() {
        return this.getString(BLINK_COMPUTED_COLUMNS_SQL_KEY, null);
    }

    public void putRowTimeField(String fieldName) {
        Preconditions.checkArgument(fieldName != null);
        this.setString(BLINK_ROWTIME_FIELD_KEY, fieldName);
    }

    public String readRowTimeField() {
        return this.getString(BLINK_ROWTIME_FIELD_KEY, null);
    }

    public void putWatermarkOffset(long offset) {
        this.setString(BLINK_ROWTIME_FIELD_KEY, offset + "");
    }

    public long readWatermarkOffset() {
        return this.getLong(BLINK_WATERMARK_OFFSET_KEY, -1L);
    }

    public void putTableComment(String comment) {
        Preconditions.checkArgument(comment != null);
        this.setString(BLINK_TABLE_COMMENT_KEY, comment);
    }

    public String readTableComment() {
        return this.getString(BLINK_TABLE_COMMENT_KEY, null);
    }
}

