/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util.collections;

import org.apache.flink.table.util.collections.OptimizableHashSet;
import org.apache.flink.table.util.hash.Murmur32;

public class FloatSet
extends OptimizableHashSet {
    private float[] key;

    public FloatSet(int expected, float f) {
        super(expected, f);
        this.key = new float[this.n + 1];
    }

    public FloatSet(int expected) {
        this(expected, 0.75f);
    }

    public FloatSet() {
        this(16, 0.75f);
    }

    public boolean add(float k) {
        int intKey = Float.floatToIntBits(k);
        if (intKey == 0) {
            if (this.containsZero) {
                return false;
            }
            this.containsZero = true;
        } else {
            float[] key = this.key;
            int pos = Murmur32.fmix(intKey) & this.mask;
            int curr = Float.floatToIntBits(key[pos]);
            if (curr != 0) {
                if (curr == intKey) {
                    return false;
                }
                while ((curr = Float.floatToIntBits(key[pos = pos + 1 & this.mask])) != 0) {
                    if (curr != intKey) continue;
                    return false;
                }
            }
            key[pos] = k;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(OptimizableHashSet.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    public boolean contains(float k) {
        int intKey = Float.floatToIntBits(k);
        if (intKey == 0) {
            return this.containsZero;
        }
        float[] key = this.key;
        int pos = Murmur32.fmix(intKey) & this.mask;
        int curr = Float.floatToIntBits(key[pos]);
        if (curr == 0) {
            return false;
        }
        if (intKey == curr) {
            return true;
        }
        while ((curr = Float.floatToIntBits(key[pos = pos + 1 & this.mask])) != 0) {
            if (intKey != curr) continue;
            return true;
        }
        return false;
    }

    private void rehash(int newN) {
        float[] key = this.key;
        int mask = newN - 1;
        float[] newKey = new float[newN + 1];
        int i = this.n;
        int j2 = this.realSize();
        while (j2-- != 0) {
            while (Float.floatToIntBits(key[--i]) == 0) {
            }
            int pos = Murmur32.fmix(Float.floatToIntBits(key[i])) & mask;
            if (Float.floatToIntBits(newKey[pos]) != 0) {
                while (Float.floatToIntBits(newKey[pos = pos + 1 & mask]) != 0) {
                }
            }
            newKey[pos] = key[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = OptimizableHashSet.maxFill(this.n, this.f);
        this.key = newKey;
    }

    @Override
    public void optimize() {
    }
}

