/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util.resource;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.table.util.resource.StreamEdgeProperty;
import org.apache.flink.table.util.resource.StreamGraphProperty;
import org.apache.flink.table.util.resource.StreamNodeProperty;
import org.apache.flink.table.util.resource.StreamNodeUtil;

public class StreamGraphConfigurer {
    public static void configure(StreamGraph graph, StreamGraphProperty property) {
        if (graph == null || property == null) {
            return;
        }
        Map<String, StreamNode> existedUidMap = StreamNodeUtil.setUid(graph);
        HashMap<String, Integer> transformationIdMap = new HashMap<String, Integer>();
        int edgesInStreamGraph = 0;
        for (StreamNode node : graph.getStreamNodes()) {
            edgesInStreamGraph += node.getInEdges().size();
            transformationIdMap.put(node.getTransformationUID(), node.getId());
        }
        if (edgesInStreamGraph != property.getStreamEdgeProperties().size() || graph.getStreamNodes().size() != property.getStreamNodeProperties().size()) {
            throw new RuntimeException("Node or edge number in stream graph and json file not matched, please generate a new json.");
        }
        for (StreamNodeProperty nodeProperty : property.getStreamNodeProperties()) {
            Integer nodeId = (Integer)transformationIdMap.get(nodeProperty.getUid());
            if (nodeId == null) {
                throw new RuntimeException("Fail to apply resource configuration file, node " + nodeProperty.toString() + " not found.");
            }
            StreamNode node = graph.getStreamNode(nodeId);
            if (node == null) {
                throw new RuntimeException("Fail to apply resource configuration file, node " + nodeProperty.toString() + " not found.");
            }
            nodeProperty.apple(node);
        }
        for (StreamEdgeProperty edgeProperty : property.getStreamEdgeProperties()) {
            try {
                StreamEdge edge = (StreamEdge)graph.getStreamEdges(((Integer)transformationIdMap.get(edgeProperty.getSource())).intValue(), ((Integer)transformationIdMap.get(edgeProperty.getTarget())).intValue()).get(edgeProperty.getIndex());
                if (edge == null) {
                    throw new RuntimeException("Fail to apply resource configuration file, edge " + edgeProperty.toString() + " not found.");
                }
                edgeProperty.apply(edge, graph);
            }
            catch (Exception ex) {
                throw new RuntimeException("Fail to apply resource configuration file, edge " + edgeProperty.toString() + " not found.");
            }
        }
        StreamNodeUtil.clearAppendUids(graph, existedUidMap);
    }
}

