/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util.resource;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.table.util.resource.StreamEdgeProperty;
import org.apache.flink.table.util.resource.StreamGraphProperty;
import org.apache.flink.table.util.resource.StreamNodeProperty;
import org.apache.flink.table.util.resource.StreamNodeUtil;
import org.apache.flink.table.util.resource.StringUtil;
import org.apache.flink.util.Preconditions;

public class StreamGraphPropertyGenerator {
    public static StreamGraphProperty generateProperties(StreamGraph streamGraph) {
        Preconditions.checkNotNull(streamGraph, "streamGraph cannot be null");
        StreamGraphProperty properties = new StreamGraphProperty();
        HashMap<String, StreamNodeProperty> uidToNodeProperties = new HashMap<String, StreamNodeProperty>();
        HashMap<Integer, String> nodeIdMap = new HashMap<Integer, String>();
        Map<String, StreamNode> existedUidMap = StreamNodeUtil.setUid(streamGraph);
        for (StreamNode streamNode : streamGraph.getStreamNodes()) {
            ResourceSpec minResourceSpec;
            String uid = streamNode.getTransformationUID();
            nodeIdMap.put(streamNode.getId(), uid);
            StreamNodeProperty streamNodeProperty = new StreamNodeProperty(uid);
            uidToNodeProperties.put(uid, streamNodeProperty);
            streamNodeProperty.setName(StreamGraphPropertyGenerator.getNodeName(streamNode.getOperatorName()));
            if (streamNode.getInEdges().isEmpty()) {
                streamNodeProperty.setPact("Source");
            } else if (streamNode.getOutEdges().isEmpty()) {
                streamNodeProperty.setPact("Sink");
            } else {
                streamNodeProperty.setPact("Operator");
            }
            streamNodeProperty.setName(StreamGraphPropertyGenerator.getNodeName(streamNode.getOperatorName()));
            int nodeMaxParallel = StreamNodeUtil.getMaxParallelism(streamNode);
            int maxParallelism = nodeMaxParallel > 0 ? nodeMaxParallel : 32768;
            streamNodeProperty.setMaxParallelism(maxParallelism);
            if (streamNode.getParallelism() > 0) {
                streamNodeProperty.setParallelism(streamNode.getParallelism());
            }
            Preconditions.checkArgument((minResourceSpec = streamNode.getMinResources()) != null, "resource can not be null.");
            streamNodeProperty.setCpuCores(minResourceSpec.getCpuCores());
            streamNodeProperty.setHeapMemoryInMB(minResourceSpec.getHeapMemory());
            streamNodeProperty.setDirectMemoryInMB(minResourceSpec.getDirectMemory());
            streamNodeProperty.setNativeMemoryInMB(minResourceSpec.getNativeMemory());
            streamNodeProperty.setGpuLoad(minResourceSpec.getGPUResource());
            if (minResourceSpec.getExtendedResources().containsKey("MANAGED_MEMORY_MB")) {
                streamNodeProperty.setManagedMemoryInMB((int)minResourceSpec.getExtendedResources().get("MANAGED_MEMORY_MB").getValue());
            }
            if (minResourceSpec.getExtendedResources().containsKey("FLOATING_MANAGED_MEMORY_MB")) {
                streamNodeProperty.setFloatingManagedMemoryInMB((int)minResourceSpec.getExtendedResources().get("FLOATING_MANAGED_MEMORY_MB").getValue());
            }
            properties.getStreamNodeProperties().add(streamNodeProperty);
        }
        StreamNodeUtil.clearAppendUids(streamGraph, existedUidMap);
        for (StreamNode source : streamGraph.getStreamNodes()) {
            HashMap<Integer, Integer> edgeCounts = new HashMap<Integer, Integer>();
            for (StreamEdge edge : source.getOutEdges()) {
                edgeCounts.putIfAbsent(edge.getTargetId(), 0);
                int index = edgeCounts.put(edge.getTargetId(), 1 + (Integer)edgeCounts.get(edge.getTargetId()));
                StreamEdgeProperty streamEdgeProperty = new StreamEdgeProperty((String)nodeIdMap.get(edge.getSourceId()), (String)nodeIdMap.get(edge.getTargetId()), index);
                streamEdgeProperty.setShipStrategy(edge.getPartitioner().toString());
                StreamNodeProperty sourceNode = (StreamNodeProperty)uidToNodeProperties.get(streamEdgeProperty.getSource());
                StreamNodeProperty targetNode = (StreamNodeProperty)uidToNodeProperties.get(streamEdgeProperty.getTarget());
                if (sourceNode.getParallelism() == targetNode.getParallelism() && sourceNode.getMaxParallelism() == targetNode.getMaxParallelism() && StreamEdgeProperty.STRATEGY_UPDATABLE.contains(streamEdgeProperty.getShipStrategy())) {
                    streamEdgeProperty.setShipStrategy("FORWARD");
                }
                properties.getStreamEdgeProperties().add(streamEdgeProperty);
            }
        }
        return properties;
    }

    private static String getNodeName(String nodeName) {
        return StringUtil.filterSpecChars(nodeName.trim()).replaceFirst("Source: ", "").replaceFirst("Sink: ", "");
    }
}

