/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.CharBuffer;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.types.ResettableValue;
import org.apache.flink.util.Preconditions;

@Public
public class StringValue
implements NormalizableKey<StringValue>,
CharSequence,
ResettableValue<StringValue>,
CopyableValue<StringValue>,
Appendable {
    private static final long serialVersionUID = 1L;
    private static final char[] EMPTY_STRING = new char[0];
    private static final int HIGH_BIT = 128;
    private static final int HIGH_BIT2 = 8192;
    private static final int HIGH_BIT2_MASK = 192;
    private char[] value = EMPTY_STRING;
    private int len;
    private int hashCode;

    public StringValue() {
    }

    public StringValue(CharSequence value) {
        this.setValue(value);
    }

    public StringValue(StringValue value) {
        this.setValue(value);
    }

    public StringValue(StringValue value, int offset, int len) {
        this.setValue(value, offset, len);
    }

    public void setLength(int len) {
        if (len < 0 || len > this.len) {
            throw new IllegalArgumentException("Length must be between 0 and the current length.");
        }
        this.len = len;
    }

    public char[] getCharArray() {
        return this.value;
    }

    public String getValue() {
        return this.toString();
    }

    @Override
    public void setValue(CharSequence value) {
        Preconditions.checkNotNull(value);
        this.setValue(value, 0, value.length());
    }

    @Override
    public void setValue(StringValue value) {
        Preconditions.checkNotNull(value);
        this.setValue(value.value, 0, value.len);
    }

    public void setValue(StringValue value, int offset, int len) {
        Preconditions.checkNotNull(value);
        this.setValue(value.value, offset, len);
    }

    public void setValue(CharSequence value, int offset, int len) {
        Preconditions.checkNotNull(value);
        if (offset < 0 || len < 0 || offset > value.length() - len) {
            throw new IndexOutOfBoundsException("offset: " + offset + " len: " + len + " value.len: " + len);
        }
        this.ensureSize(len);
        this.len = len;
        for (int i = 0; i < len; ++i) {
            this.value[i] = value.charAt(offset + i);
        }
        this.len = len;
        this.hashCode = 0;
    }

    @Override
    public void setValue(CharBuffer buffer) {
        Preconditions.checkNotNull(buffer);
        int len = buffer.length();
        this.ensureSize(len);
        buffer.get(this.value, 0, len);
        this.len = len;
        this.hashCode = 0;
    }

    public void setValue(char[] chars, int offset, int len) {
        Preconditions.checkNotNull(chars);
        if (offset < 0 || len < 0 || offset > chars.length - len) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureSize(len);
        System.arraycopy(chars, offset, this.value, 0, len);
        this.len = len;
        this.hashCode = 0;
    }

    public void setValueAscii(byte[] bytes, int offset, int len) {
        if (bytes == null) {
            throw new NullPointerException("Bytes must not be null");
        }
        if (len < 0 | offset < 0 | offset > bytes.length - len) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureSize(len);
        this.len = len;
        this.hashCode = 0;
        char[] chars = this.value;
        int i = 0;
        int limit = offset + len;
        while (offset < limit) {
            chars[i] = (char)(bytes[offset] & 0xFF);
            ++offset;
            ++i;
        }
    }

    public StringValue substring(int start) {
        return this.substring(start, this.len);
    }

    public StringValue substring(int start, int end) {
        return new StringValue(this, start, end - start);
    }

    public void substring(StringValue target, int start) {
        this.substring(target, start, this.len);
    }

    public void substring(StringValue target, int start, int end) {
        target.setValue(this, start, end - start);
    }

    public int find(CharSequence str) {
        return this.find(str, 0);
    }

    public int find(CharSequence str, int start) {
        int pLen = this.len;
        int sLen = str.length();
        if (sLen == 0) {
            throw new IllegalArgumentException("Cannot find empty string.");
        }
        int pPos = start;
        char first = str.charAt(0);
        while (pPos < pLen) {
            if (first != this.value[pPos++]) continue;
            int fallBackPosition = pPos;
            int sPos = 1;
            boolean found = true;
            while (sPos < sLen) {
                if (pPos >= pLen) {
                    pPos = fallBackPosition;
                    found = false;
                    break;
                }
                if (str.charAt(sPos++) == this.value[pPos++]) continue;
                pPos = fallBackPosition;
                found = false;
                break;
            }
            if (!found) continue;
            return fallBackPosition - 1;
        }
        return -1;
    }

    public boolean startsWith(CharSequence prefix, int startIndex) {
        char[] thisChars = this.value;
        int pLen = this.len;
        int sLen = prefix.length();
        if (startIndex < 0 || startIndex > pLen - sLen) {
            return false;
        }
        int sPos = 0;
        while (sPos < sLen) {
            if (thisChars[startIndex++] == prefix.charAt(sPos++)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    @Override
    public Appendable append(char c) {
        this.grow(this.len + 1);
        this.value[this.len++] = c;
        return this;
    }

    @Override
    public Appendable append(CharSequence csq) {
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        int otherLen = end - start;
        this.grow(this.len + otherLen);
        for (int pos = start; pos < end; ++pos) {
            this.value[this.len + pos] = csq.charAt(pos);
        }
        this.len += otherLen;
        return this;
    }

    public Appendable append(StringValue csq) {
        this.append(csq, 0, csq.length());
        return this;
    }

    public Appendable append(StringValue csq, int start, int end) {
        int otherLen = end - start;
        this.grow(this.len + otherLen);
        System.arraycopy(csq.value, start, this.value, this.len, otherLen);
        this.len += otherLen;
        return this;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        int len = in.readUnsignedByte();
        if (len >= 128) {
            int curr;
            int shift = 7;
            len &= 0x7F;
            while ((curr = in.readUnsignedByte()) >= 128) {
                len |= (curr & 0x7F) << shift;
                shift += 7;
            }
            len |= curr << shift;
        }
        this.len = len;
        this.hashCode = 0;
        this.ensureSize(len);
        char[] data = this.value;
        for (int i = 0; i < len; ++i) {
            int curr;
            int c = in.readUnsignedByte();
            if (c < 128) {
                data[i] = (char)c;
                continue;
            }
            int shift = 7;
            c &= 0x7F;
            while ((curr = in.readUnsignedByte()) >= 128) {
                c |= (curr & 0x7F) << shift;
                shift += 7;
            }
            data[i] = (char)(c |= curr << shift);
        }
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        int len;
        for (len = this.len; len >= 128; len >>>= 7) {
            out.write(len | 0x80);
        }
        out.write(len);
        for (int i = 0; i < this.len; ++i) {
            int c;
            for (c = this.value[i]; c >= 128; c >>>= 7) {
                out.write(c | 0x80);
            }
            out.write(c);
        }
    }

    @Override
    public String toString() {
        return new String(this.value, 0, this.len);
    }

    @Override
    public int compareTo(StringValue other) {
        int len1 = this.len;
        int len2 = other.len;
        int n = Math.min(len1, len2);
        char[] v1 = this.value;
        char[] v2 = other.value;
        for (int k = 0; k < n; ++k) {
            char c1 = v1[k];
            char c2 = v2[k];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    @Override
    public int hashCode() {
        int h = this.hashCode;
        if (h == 0 && this.len > 0) {
            int off = 0;
            char[] val = this.value;
            int len = this.len;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + val[off++];
            }
            this.hashCode = h;
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StringValue) {
            StringValue other = (StringValue)obj;
            int len = this.len;
            if (len == other.len) {
                char[] tc = this.value;
                char[] oc = other.value;
                int i = 0;
                int j2 = 0;
                while (len-- != 0) {
                    if (tc[i++] == oc[j2++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        if (index < this.len) {
            return this.value[index];
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new StringValue(this, start, end - start);
    }

    @Override
    public int getMaxNormalizedKeyLen() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void copyNormalizedKey(MemorySegment target, int offset, int len) {
        char[] chars = this.value;
        int limit = offset + len;
        int end = this.len;
        int pos = 0;
        while (pos < end && offset < limit) {
            char c;
            if ((c = chars[pos++]) < '\u0080') {
                target.put(offset++, (byte)c);
                continue;
            }
            if (c < '\u2000') {
                target.put(offset++, (byte)(c >>> 7 | 0x80));
                if (offset >= limit) continue;
                target.put(offset++, (byte)c);
                continue;
            }
            target.put(offset++, (byte)(c >>> 10 | 0xC0));
            if (offset < limit) {
                target.put(offset++, (byte)(c >>> 2));
            }
            if (offset >= limit) continue;
            target.put(offset++, (byte)c);
        }
        while (offset < limit) {
            target.put(offset++, (byte)0);
        }
    }

    @Override
    public int getBinaryLength() {
        return -1;
    }

    @Override
    public void copyTo(StringValue target) {
        target.len = this.len;
        target.hashCode = this.hashCode;
        target.ensureSize(this.len);
        System.arraycopy(this.value, 0, target.value, 0, this.len);
    }

    @Override
    public StringValue copy() {
        return new StringValue(this);
    }

    @Override
    public void copy(DataInputView in, DataOutputView target) throws IOException {
        int len = in.readUnsignedByte();
        target.writeByte(len);
        if (len >= 128) {
            int curr;
            int shift = 7;
            len &= 0x7F;
            while ((curr = in.readUnsignedByte()) >= 128) {
                len |= (curr & 0x7F) << shift;
                shift += 7;
                target.writeByte(curr);
            }
            len |= curr << shift;
            target.writeByte(curr);
        }
        for (int i = 0; i < len; ++i) {
            int c = in.readUnsignedByte();
            target.writeByte(c);
            while (c >= 128) {
                c = in.readUnsignedByte();
                target.writeByte(c);
            }
        }
    }

    private void ensureSize(int size) {
        if (this.value.length < size) {
            this.value = new char[size];
        }
    }

    private void grow(int size) {
        if (this.value.length < size) {
            char[] value = new char[Math.max(this.value.length * 3 / 2, size)];
            System.arraycopy(this.value, 0, value, 0, this.len);
            this.value = value;
        }
    }

    public static String readString(DataInput in) throws IOException {
        int len = in.readUnsignedByte();
        if (len == 0) {
            return null;
        }
        if (len >= 128) {
            int curr;
            int shift = 7;
            len &= 0x7F;
            while ((curr = in.readUnsignedByte()) >= 128) {
                len |= (curr & 0x7F) << shift;
                shift += 7;
            }
            len |= curr << shift;
        }
        char[] data = new char[--len];
        for (int i = 0; i < len; ++i) {
            int curr;
            int c = in.readUnsignedByte();
            if (c < 128) {
                data[i] = (char)c;
                continue;
            }
            int shift = 7;
            c &= 0x7F;
            while ((curr = in.readUnsignedByte()) >= 128) {
                c |= (curr & 0x7F) << shift;
                shift += 7;
            }
            data[i] = (char)(c |= curr << shift);
        }
        return new String(data, 0, len);
    }

    public static final void writeString(CharSequence cs, DataOutput out) throws IOException {
        if (cs != null) {
            int lenToWrite = cs.length() + 1;
            if (lenToWrite < 0) {
                throw new IllegalArgumentException("CharSequence is too long.");
            }
            while (lenToWrite >= 128) {
                out.write(lenToWrite | 0x80);
                lenToWrite >>>= 7;
            }
            out.write(lenToWrite);
            for (int i = 0; i < cs.length(); ++i) {
                int c;
                for (c = cs.charAt(i); c >= 128; c >>>= 7) {
                    out.write(c | 0x80);
                }
                out.write(c);
            }
        } else {
            out.write(0);
        }
    }

    public static final void copyString(DataInput in, DataOutput out) throws IOException {
        int len = in.readUnsignedByte();
        out.writeByte(len);
        if (len >= 128) {
            int curr;
            int shift = 7;
            len &= 0x7F;
            while ((curr = in.readUnsignedByte()) >= 128) {
                out.writeByte(curr);
                len |= (curr & 0x7F) << shift;
                shift += 7;
            }
            out.writeByte(curr);
            len |= curr << shift;
        }
        --len;
        for (int i = 0; i < len; ++i) {
            int c = in.readUnsignedByte();
            out.writeByte(c);
            while (c >= 128) {
                c = in.readUnsignedByte();
                out.writeByte(c);
            }
        }
    }
}

