/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.table.util.resource;

import org.apache.flink.annotation.VisibleForTesting;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.TreeSet;

/**
 * Properties for StreamGraph.
 */
@JsonInclude(JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(ignoreUnknown = true)
public class StreamGraphProperty extends AbstractJsonSerializable {

	@JsonProperty("nodes")
	private TreeSet<StreamNodeProperty> streamNodeProperties = new TreeSet<>();

	@JsonProperty("links")
	private TreeSet<StreamEdgeProperty> streamEdgeProperties = new TreeSet<>();

	@VisibleForTesting
	public static StreamGraphProperty fromJson(String json) {
		return fromJson(json, StreamGraphProperty.class);
	}

	public TreeSet<StreamNodeProperty> getStreamNodeProperties() {
		return streamNodeProperties;
	}

	public TreeSet<StreamEdgeProperty> getStreamEdgeProperties() {
		return streamEdgeProperties;
	}

}

