/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.table.validate

import org.apache.flink.table.calcite.FlinkTypeFactory
import org.apache.flink.table.catalog.{CatalogFunction, FlinkTempFunction, ReadableCatalog}

import org.apache.calcite.sql.SqlFunction

/**
  * Utils for FunctionCatalog.
  */
object FunctionCatalogUtils {

  /**
    * Convert [[CatalogFunction]] to calcite SqlFunction.
    * note: tableEnvironment should not be null
    */
  def toSqlFunction(
     catalog: ReadableCatalog,
     funcName: String,
     catalogFunc: CatalogFunction,
     typeFactory: FlinkTypeFactory): SqlFunction = {
    catalogFunc match {
      case tempFunc: FlinkTempFunction => tempFunc.getSqlFunction
      case _ =>
        catalog.getSqlFunction(
          Thread.currentThread().getContextClassLoader,
          funcName,
          catalogFunc.getClazzName,
          typeFactory)
    }
  }
}
