/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.avatica.util.UnsynchronizedBuffer;

public class AvaticaUtils {
    private static final Map<Class, Class> BOX;
    private static final MethodHandle SET_LARGE_MAX_ROWS;
    private static final MethodHandle GET_LARGE_MAX_ROWS;
    private static final MethodHandle GET_LARGE_UPDATE_COUNT;
    private static final MethodHandle EXECUTE_LARGE_BATCH;
    private static final Set<String> UNIQUE_STRINGS;
    private static final ThreadLocal<byte[]> PER_THREAD_BUFFER;

    private AvaticaUtils() {
    }

    private static MethodHandle method(Class returnType2, Class targetType, String name, Class ... argTypes) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.findVirtual(targetType, name, MethodType.methodType(returnType2, targetType, argTypes));
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
        catch (IllegalAccessException e3) {
            throw new RuntimeException(e3);
        }
    }

    public static void discard(Object o) {
    }

    public static <T> T remark(T remark) {
        return remark;
    }

    public static boolean upgrade(String remark) {
        AvaticaUtils.discard(remark);
        return false;
    }

    public static List<?> primitiveList(final Object array2) {
        return new AbstractList<Object>(){

            @Override
            public Object get(int index) {
                return Array.get(array2, index);
            }

            @Override
            public int size() {
                return Array.getLength(array2);
            }
        };
    }

    public static String camelToUpper(String name) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buf.append('_');
            } else {
                c = Character.toUpperCase(c);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String toCamelCase(String name) {
        StringBuilder buf = new StringBuilder();
        int nextUpper = -1;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                nextUpper = i + 1;
                continue;
            }
            c = nextUpper == i ? Character.toUpperCase(c) : Character.toLowerCase(c);
            buf.append(c);
        }
        return buf.toString();
    }

    public static Class box(Class clazz) {
        if (clazz.isPrimitive()) {
            return BOX.get(clazz);
        }
        return clazz;
    }

    public static <T> T instantiatePlugin(Class<T> pluginClass, String className) {
        try {
            if (className.contains("#")) {
                try {
                    int i = className.indexOf(35);
                    String left = className.substring(0, i);
                    String right = className.substring(i + 1);
                    Class<?> clazz = Class.forName(left);
                    Field field = clazz.getField(right);
                    return pluginClass.cast(field.get(null));
                }
                catch (NoSuchFieldException i) {
                    // empty catch block
                }
            }
            Class<?> clazz = Class.forName(className);
            assert (pluginClass.isAssignableFrom(clazz));
            try {
                Field field = clazz.getField("INSTANCE");
                return pluginClass.cast(field.get(null));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return (T)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Property '" + className + "' not valid for plugin type " + pluginClass.getName(), e2);
        }
    }

    public static String readFully(InputStream inputStream) throws IOException {
        return AvaticaUtils.readFully(inputStream, new UnsynchronizedBuffer(1024));
    }

    public static String readFully(InputStream inputStream, UnsynchronizedBuffer buffer) throws IOException {
        byte[] bytes = AvaticaUtils._readFully(inputStream, buffer);
        return new String(bytes, 0, bytes.length, StandardCharsets.UTF_8);
    }

    public static byte[] readFullyToBytes(InputStream inputStream) throws IOException {
        return AvaticaUtils.readFullyToBytes(inputStream, new UnsynchronizedBuffer(1024));
    }

    public static byte[] readFullyToBytes(InputStream inputStream, UnsynchronizedBuffer buffer) throws IOException {
        return AvaticaUtils._readFully(inputStream, buffer);
    }

    static byte[] _readFully(InputStream inputStream, UnsynchronizedBuffer buffer) throws IOException {
        int count;
        byte[] bytes = PER_THREAD_BUFFER.get();
        while ((count = inputStream.read(bytes, 0, bytes.length)) >= 0) {
            buffer.write(bytes, 0, count);
        }
        return buffer.toArray();
    }

    public static void setLargeMaxRows(Statement statement, long n) throws SQLException {
        if (SET_LARGE_MAX_ROWS != null) {
            try {
                SET_LARGE_MAX_ROWS.invokeExact(n);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Error | RuntimeException | SQLException e2) {
                throw e2;
            }
            catch (Throwable e3) {
                throw new RuntimeException(e3);
            }
        }
        int i = (int)Math.max(Math.min(n, Integer.MAX_VALUE), Integer.MIN_VALUE);
        statement.setMaxRows(i);
    }

    public static long getLargeMaxRows(Statement statement) throws SQLException {
        if (GET_LARGE_MAX_ROWS != null) {
            try {
                return GET_LARGE_MAX_ROWS.invokeExact();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Error | RuntimeException | SQLException e2) {
                throw e2;
            }
            catch (Throwable e3) {
                throw new RuntimeException(e3);
            }
        }
        return statement.getMaxRows();
    }

    public static long getLargeUpdateCount(Statement statement) throws SQLException {
        if (GET_LARGE_UPDATE_COUNT != null) {
            try {
                return GET_LARGE_UPDATE_COUNT.invokeExact();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Error | RuntimeException | SQLException e2) {
                throw e2;
            }
            catch (Throwable e3) {
                throw new RuntimeException(e3);
            }
        }
        return statement.getUpdateCount();
    }

    public static long[] executeLargeBatch(Statement statement) throws SQLException {
        if (EXECUTE_LARGE_BATCH != null) {
            try {
                return EXECUTE_LARGE_BATCH.invokeExact();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Error | RuntimeException | SQLException e2) {
                throw e2;
            }
            catch (Throwable e3) {
                throw new RuntimeException(e3);
            }
        }
        return AvaticaUtils.toLongs(statement.executeBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unique(String base) {
        Set<String> set = UNIQUE_STRINGS;
        synchronized (set) {
            String s = base;
            while (!UNIQUE_STRINGS.add(s)) {
                s = base + "_" + UNIQUE_STRINGS.size();
            }
            return s;
        }
    }

    public static int toSaturatedInt(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public static int[] toSaturatedInts(long[] longs) {
        int[] ints = new int[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            ints[i] = AvaticaUtils.toSaturatedInt(longs[i]);
        }
        return ints;
    }

    public static long[] toLongs(int[] ints) {
        long[] longs = new long[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            longs[i] = ints[i];
        }
        return longs;
    }

    static {
        SET_LARGE_MAX_ROWS = AvaticaUtils.method(Void.TYPE, Statement.class, "setLargeMaxRows", Long.TYPE);
        GET_LARGE_MAX_ROWS = AvaticaUtils.method(Long.TYPE, Statement.class, "getLargeMaxRows", new Class[0]);
        GET_LARGE_UPDATE_COUNT = AvaticaUtils.method(Void.TYPE, Statement.class, "getLargeUpdateCount", new Class[0]);
        EXECUTE_LARGE_BATCH = AvaticaUtils.method(long[].class, Statement.class, "executeLargeBatch", new Class[0]);
        UNIQUE_STRINGS = new HashSet<String>();
        PER_THREAD_BUFFER = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[4096];
            }
        };
        BOX = new HashMap<Class, Class>();
        BOX.put(Boolean.TYPE, Boolean.class);
        BOX.put(Byte.TYPE, Byte.class);
        BOX.put(Character.TYPE, Character.class);
        BOX.put(Short.TYPE, Short.class);
        BOX.put(Integer.TYPE, Integer.class);
        BOX.put(Long.TYPE, Long.class);
        BOX.put(Float.TYPE, Float.class);
        BOX.put(Double.TYPE, Double.class);
    }
}

