/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.Pair;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class MetadataDef<M extends Metadata> {
    public final Class<M> metadataClass;
    public final Class<? extends MetadataHandler<M>> handlerClass;
    public final ImmutableList<Method> methods;

    private MetadataDef(Class<M> metadataClass, Class<? extends MetadataHandler<M>> handlerClass, Method ... methods) {
        this.metadataClass = metadataClass;
        this.handlerClass = handlerClass;
        this.methods = ImmutableList.copyOf(methods);
        Method[] handlerMethods = handlerClass.getDeclaredMethods();
        assert (handlerMethods.length == methods.length);
        for (Pair<Method, Method> pair : Pair.zip(methods, handlerMethods)) {
            List<Class<?>> leftTypes = Arrays.asList(((Method)pair.left).getParameterTypes());
            List<Class<?>> rightTypes = Arrays.asList(((Method)pair.right).getParameterTypes());
            assert (leftTypes.size() + 2 == rightTypes.size());
            assert (RelNode.class.isAssignableFrom(rightTypes.get(0)));
            assert (RelMetadataQuery.class == rightTypes.get(1));
            assert (leftTypes.equals(rightTypes.subList(2, rightTypes.size())));
        }
    }

    public static <M extends Metadata> MetadataDef<M> of(Class<M> metadataClass, Class<? extends MetadataHandler<M>> handlerClass, Method ... methods) {
        return new MetadataDef<M>(metadataClass, handlerClass, methods);
    }
}

