/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class RexPermuteInputsShuttle
extends RexShuttle {
    private final Mappings.TargetMapping mapping;
    private final ImmutableList<RelDataTypeField> fields;

    public RexPermuteInputsShuttle(Mappings.TargetMapping mapping, RelNode ... inputs) {
        this(mapping, RexPermuteInputsShuttle.fields(inputs));
    }

    private RexPermuteInputsShuttle(Mappings.TargetMapping mapping, ImmutableList<RelDataTypeField> fields2) {
        this.mapping = mapping;
        this.fields = fields2;
    }

    public static RexPermuteInputsShuttle of(Mappings.TargetMapping mapping) {
        return new RexPermuteInputsShuttle(mapping, ImmutableList.of());
    }

    private static ImmutableList<RelDataTypeField> fields(RelNode[] inputs) {
        ImmutableList.Builder fields2 = ImmutableList.builder();
        for (RelNode input : inputs) {
            fields2.addAll(input.getRowType().getFieldList());
        }
        return fields2.build();
    }

    @Override
    public RexNode visitInputRef(RexInputRef local) {
        int index = local.getIndex();
        int target = this.mapping.getTarget(index);
        return new RexInputRef(target, local.getType());
    }

    @Override
    public RexNode visitCall(RexCall call) {
        String name;
        int i;
        if (call.getOperator() == RexBuilder.GET_OPERATOR && (i = RexPermuteInputsShuttle.lookup(this.fields, name = (String)((RexLiteral)call.getOperands().get(1)).getValue2())) >= 0) {
            return RexInputRef.of(i, this.fields);
        }
        return super.visitCall(call);
    }

    private static int lookup(List<RelDataTypeField> fields2, String name) {
        for (int i = 0; i < fields2.size(); ++i) {
            RelDataTypeField field = fields2.get(i);
            if (!field.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }
}

