/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.schema.ExtensibleTable;
import org.apache.calcite.schema.ModifiableView;
import org.apache.calcite.schema.Path;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableMap;

public class ModifiableViewTable
extends ViewTable
implements ModifiableView,
Wrapper {
    private final Table table;
    private final Path tablePath;
    private final RexNode constraint;
    private final ImmutableIntList columnMapping;
    private final InitializerExpressionFactory initializerExpressionFactory;

    public ModifiableViewTable(Type elementType, RelProtoDataType rowType, String viewSql, List<String> schemaPath, List<String> viewPath, Table table, Path tablePath, RexNode constraint, ImmutableIntList columnMapping) {
        super(elementType, rowType, viewSql, schemaPath, viewPath);
        this.table = table;
        this.tablePath = tablePath;
        this.constraint = constraint;
        this.columnMapping = columnMapping;
        this.initializerExpressionFactory = new ModifiableViewTableInitializerExpressionFactory();
    }

    @Override
    public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
        return rexBuilder.copy(this.constraint);
    }

    @Override
    public ImmutableIntList getColumnMapping() {
        return this.columnMapping;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public Path getTablePath() {
        return this.tablePath;
    }

    @Override
    public <C> C unwrap(Class<C> aClass) {
        if (aClass.isInstance(this.initializerExpressionFactory)) {
            return aClass.cast(this.initializerExpressionFactory);
        }
        if (aClass.isInstance(this.table)) {
            return aClass.cast(this.table);
        }
        return super.unwrap(aClass);
    }

    public final ModifiableViewTable extend(List<RelDataTypeField> extendedColumns, RelDataTypeFactory typeFactory) {
        ExtensibleTable underlying = this.unwrap(ExtensibleTable.class);
        assert (underlying != null);
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        RelDataType rowType = this.getRowType(typeFactory);
        for (RelDataTypeField column : rowType.getFieldList()) {
            ((RelDataTypeFactory.Builder)builder).add(column);
        }
        for (RelDataTypeField column : extendedColumns) {
            ((RelDataTypeFactory.Builder)builder).add(column);
        }
        RelDataType newRowType = builder.build();
        ImmutableIntList newColumnMapping = ModifiableViewTable.getNewColumnMapping(underlying, this.getColumnMapping(), extendedColumns, typeFactory);
        List<RelDataTypeField> underlyingColumns = underlying.getRowType(typeFactory).getFieldList();
        List<RelDataTypeField> columnsOfExtendedBaseTable = RelOptUtil.deduplicateColumns(underlyingColumns, extendedColumns);
        List<RelDataTypeField> extendColumnsOfBaseTable = columnsOfExtendedBaseTable.subList(underlyingColumns.size(), columnsOfExtendedBaseTable.size());
        Table extendedTable = underlying.extend(extendColumnsOfBaseTable);
        return this.extend(extendedTable, RelDataTypeImpl.proto(newRowType), newColumnMapping);
    }

    private static ImmutableIntList getNewColumnMapping(Table underlying, ImmutableIntList oldColumnMapping, List<RelDataTypeField> extendedColumns, RelDataTypeFactory typeFactory) {
        List<RelDataTypeField> baseColumns = underlying.getRowType(typeFactory).getFieldList();
        Map<String, Integer> nameToIndex = SqlValidatorUtil.mapNameToIndex(baseColumns);
        ImmutableList.Builder newMapping = ImmutableList.builder();
        newMapping.addAll((Iterable)oldColumnMapping);
        int newMappedIndex = baseColumns.size();
        for (RelDataTypeField extendedColumn : extendedColumns) {
            if (nameToIndex.containsKey(extendedColumn.getName())) {
                newMapping.add(nameToIndex.get(extendedColumn.getName()));
                continue;
            }
            newMapping.add((Object)newMappedIndex++);
        }
        return ImmutableIntList.copyOf(newMapping.build());
    }

    protected ModifiableViewTable extend(Table extendedTable, RelProtoDataType protoRowType, ImmutableIntList newColumnMapping) {
        return new ModifiableViewTable(this.getElementType(), protoRowType, this.getViewSql(), this.getSchemaPath(), this.getViewPath(), extendedTable, this.getTablePath(), this.constraint, newColumnMapping);
    }

    private class ModifiableViewTableInitializerExpressionFactory
    extends NullInitializerExpressionFactory {
        private final ImmutableMap<Integer, RexNode> projectMap;

        private ModifiableViewTableInitializerExpressionFactory() {
            HashMap<Integer, RexNode> projectMap = new HashMap<Integer, RexNode>();
            ArrayList<RexNode> filters = new ArrayList<RexNode>();
            RelOptUtil.inferViewPredicates(projectMap, filters, ModifiableViewTable.this.constraint);
            assert (filters.isEmpty());
            this.projectMap = ImmutableMap.copyOf(projectMap);
        }

        @Override
        public ColumnStrategy generationStrategy(RelOptTable table, int iColumn) {
            InitializerExpressionFactory initializerExpressionFactory;
            ModifiableViewTable viewTable = table.unwrap(ModifiableViewTable.class);
            assert (iColumn < viewTable.columnMapping.size());
            int mappedOrdinal = viewTable.columnMapping.get(iColumn);
            RexNode viewConstraint = this.projectMap.get(mappedOrdinal);
            if (viewConstraint != null) {
                return ColumnStrategy.DEFAULT;
            }
            Table schemaTable = viewTable.getTable();
            if (schemaTable instanceof Wrapper && (initializerExpressionFactory = ((Wrapper)((Object)schemaTable)).unwrap(InitializerExpressionFactory.class)) != null) {
                return initializerExpressionFactory.generationStrategy(table, iColumn);
            }
            return super.generationStrategy(table, iColumn);
        }

        @Override
        public RexNode newColumnDefaultValue(RelOptTable table, int iColumn, InitializerContext context) {
            InitializerExpressionFactory initializerExpressionFactory;
            ModifiableViewTable viewTable = table.unwrap(ModifiableViewTable.class);
            assert (iColumn < viewTable.columnMapping.size());
            RexBuilder rexBuilder = context.getRexBuilder();
            RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
            RelDataType viewType = viewTable.getRowType(typeFactory);
            RelDataType iType = viewType.getFieldList().get(iColumn).getType();
            int mappedOrdinal = viewTable.columnMapping.get(iColumn);
            RexNode viewConstraint = this.projectMap.get(mappedOrdinal);
            if (viewConstraint != null) {
                return rexBuilder.ensureType(iType, viewConstraint, true);
            }
            Table schemaTable = viewTable.getTable();
            if (schemaTable instanceof Wrapper && (initializerExpressionFactory = ((Wrapper)((Object)schemaTable)).unwrap(InitializerExpressionFactory.class)) != null) {
                RexNode tableConstraint = initializerExpressionFactory.newColumnDefaultValue(table, iColumn, context);
                return rexBuilder.ensureType(iType, tableConstraint, true);
            }
            return super.newColumnDefaultValue(table, iColumn, context);
        }

        @Override
        public RexNode newAttributeInitializer(RelDataType type, SqlFunction constructor, int iAttribute, List<RexNode> constructorArgs, InitializerContext context) {
            throw new UnsupportedOperationException("Not implemented - unknown requirements");
        }
    }
}

