/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions;

import org.apache.flink.api.common.functions.Merger;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.util.Preconditions;

public class ReduceMerger<T>
implements Merger<T> {
    private static final long serialVersionUID = 1L;
    private final ReduceFunction<T> reduceFunction;

    public ReduceMerger(ReduceFunction<T> reduceFunction) {
        Preconditions.checkNotNull(reduceFunction);
        this.reduceFunction = reduceFunction;
    }

    @Override
    public T merge(T value1, T value2) {
        try {
            return this.reduceFunction.reduce(value1, value2);
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not properly reduce the values.", e2);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReduceMerger that = (ReduceMerger)o;
        return this.reduceFunction.equals(that.reduceFunction);
    }

    public int hashCode() {
        return this.reduceFunction.hashCode();
    }

    public String toString() {
        return "ReduceMerger{reduceFunction=" + this.reduceFunction + "}";
    }
}

