/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class ReplicatingInputSplitAssigner
implements InputSplitAssigner {
    private InputSplit[] inputSplits;
    private int[] assignCounts;

    public ReplicatingInputSplitAssigner(Collection<InputSplit> splits) {
        this.inputSplits = new InputSplit[splits.size()];
        this.inputSplits = splits.toArray(this.inputSplits);
        this.assignCounts = new int[32];
        Arrays.fill(this.assignCounts, 0);
    }

    public ReplicatingInputSplitAssigner(InputSplit[] splits) {
        this.inputSplits = splits;
        this.assignCounts = new int[32];
        Arrays.fill(this.assignCounts, 0);
    }

    @Override
    public InputSplit getNextInputSplit(String host, int taskId) {
        Integer assignCnt;
        if (taskId < this.assignCounts.length) {
            assignCnt = this.assignCounts[taskId];
        } else {
            int newSize = this.assignCounts.length * 2;
            if (taskId >= newSize) {
                newSize = taskId;
            }
            int[] newAssignCounts = Arrays.copyOf(this.assignCounts, newSize);
            Arrays.fill(newAssignCounts, this.assignCounts.length, newSize, 0);
            assignCnt = 0;
        }
        if (assignCnt >= this.inputSplits.length) {
            return null;
        }
        InputSplit is = this.inputSplits[assignCnt];
        this.assignCounts[taskId] = assignCnt + 1;
        return is;
    }

    @Override
    public void inputSplitsAssigned(int taskId, List<InputSplit> inputSplits) {
        Integer assignCnt;
        if (taskId < this.assignCounts.length) {
            assignCnt = this.assignCounts[taskId];
        } else {
            int newSize = this.assignCounts.length * 2;
            if (taskId >= newSize) {
                newSize = taskId;
            }
            int[] newAssignCounts = Arrays.copyOf(this.assignCounts, newSize);
            Arrays.fill(newAssignCounts, this.assignCounts.length, newSize, 0);
            assignCnt = 0;
        }
        assignCnt = assignCnt + inputSplits.size();
        if (assignCnt > this.inputSplits.length) {
            throw new FlinkRuntimeException("Assigned input splits exceed total inputs for .");
        }
        this.assignCounts[taskId] = assignCnt;
    }
}

