/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.blockcompression;

import java.nio.ByteBuffer;
import org.apache.flink.api.common.io.blockcompression.InsufficientBufferException;
import org.apache.flink.util.Preconditions;

public abstract class AbstractBlockCompressor {
    private byte[] reuseSrcHeapBuff;
    private byte[] reuseDstHeapBuff;

    public abstract int getMaxCompressedSize(int var1);

    public int getMaxCompressedSize(byte[] src) {
        return this.getMaxCompressedSize(src.length);
    }

    public int compress(ByteBuffer src, ByteBuffer dst) throws InsufficientBufferException {
        return this.compress(src, 0, src.remaining(), dst, 0);
    }

    public int compress(ByteBuffer src, int srcOff, int srcLen, ByteBuffer dst, int dstOff) throws InsufficientBufferException {
        int dstArrOff;
        byte[] dstArr;
        int srcArrOff;
        byte[] srcArr;
        Preconditions.checkArgument(srcOff >= 0 && dstOff >= 0);
        if (srcOff > 0) {
            src.position(src.position() + srcOff);
        }
        if (dstOff > 0) {
            dst.position(dst.position() + dstOff);
        }
        if (src.hasArray()) {
            srcArr = src.array();
            srcArrOff = src.arrayOffset() + src.position();
            src.position(src.position() + srcLen);
        } else {
            if (this.reuseSrcHeapBuff == null || this.reuseSrcHeapBuff.length < srcLen) {
                this.reuseSrcHeapBuff = new byte[srcLen];
            }
            srcArr = this.reuseSrcHeapBuff;
            srcArrOff = 0;
            src.get(srcArr, 0, srcLen);
        }
        if (dst.hasArray()) {
            dstArr = dst.array();
            dstArrOff = dst.arrayOffset() + dst.position();
        } else {
            int len = dst.capacity() - dst.position();
            if (this.reuseDstHeapBuff == null || this.reuseDstHeapBuff.length < len) {
                this.reuseDstHeapBuff = new byte[len];
            }
            dstArr = this.reuseDstHeapBuff;
            dstArrOff = 0;
        }
        int compressedLen = this.compress(srcArr, srcArrOff, srcLen, dstArr, dstArrOff);
        if (dst.hasArray()) {
            dst.position(dst.position() + compressedLen);
        } else {
            dst.put(dstArr, dstArrOff, compressedLen);
        }
        return compressedLen;
    }

    public int compress(byte[] src, byte[] dst) throws InsufficientBufferException {
        return this.compress(src, 0, src.length, dst, 0);
    }

    public abstract int compress(byte[] var1, int var2, int var3, byte[] var4, int var5) throws InsufficientBufferException;
}

