/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.blockcompression;

import org.apache.flink.api.common.io.blockcompression.AbstractBlockCompressor;
import org.apache.flink.api.common.io.blockcompression.AbstractBlockDecompressor;
import org.apache.flink.api.common.io.blockcompression.BlockCompressionFactory;
import org.apache.flink.api.common.io.blockcompression.Lz4BlockCompressor;
import org.apache.flink.api.common.io.blockcompression.Lz4BlockDecompressor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.util.Preconditions;

public class Lz4BlockCompressionFactory
implements BlockCompressionFactory {
    private Configuration configuration;

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public AbstractBlockCompressor getCompressor() {
        Preconditions.checkArgument(this.configuration != null, "Configuration must be set!");
        return new Lz4BlockCompressor(this.configuration.getString(CoreOptions.TMP_DIRS, CoreOptions.TMP_DIRS.defaultValue()));
    }

    @Override
    public AbstractBlockDecompressor getDecompressor() {
        Preconditions.checkArgument(this.configuration != null, "Configuration must be set!");
        return new Lz4BlockDecompressor(this.configuration.getString(CoreOptions.TMP_DIRS, CoreOptions.TMP_DIRS.defaultValue()));
    }
}

