/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.util.Visitor;

@Internal
public class GenericDataSourceBase<OUT, T extends InputFormat<OUT, ?>>
extends Operator<OUT> {
    private static final String DEFAULT_NAME = "<Unnamed Generic Data Source>";
    protected final UserCodeWrapper<? extends T> formatWrapper;
    protected String statisticsKey;
    private SplitDataProperties splitProperties;

    public GenericDataSourceBase(T format2, OperatorInformation<OUT> operatorInfo, String name) {
        super(operatorInfo, name);
        if (format2 == null) {
            throw new IllegalArgumentException("Input format may not be null.");
        }
        this.formatWrapper = new UserCodeObjectWrapper<T>(format2);
    }

    public GenericDataSourceBase(T format2, OperatorInformation<OUT> operatorInfo) {
        super(operatorInfo, DEFAULT_NAME);
        if (format2 == null) {
            throw new IllegalArgumentException("Input format may not be null.");
        }
        this.formatWrapper = new UserCodeObjectWrapper<T>(format2);
    }

    public GenericDataSourceBase(Class<? extends T> format2, OperatorInformation<OUT> operatorInfo, String name) {
        super(operatorInfo, name);
        if (format2 == null) {
            throw new IllegalArgumentException("Input format may not be null.");
        }
        this.formatWrapper = new UserCodeClassWrapper<T>(format2);
    }

    public GenericDataSourceBase(Class<? extends T> format2, OperatorInformation<OUT> operatorInfo) {
        super(operatorInfo, DEFAULT_NAME);
        if (format2 == null) {
            throw new IllegalArgumentException("Input format may not be null.");
        }
        this.formatWrapper = new UserCodeClassWrapper<T>(format2);
    }

    public UserCodeWrapper<? extends T> getFormatWrapper() {
        return this.formatWrapper;
    }

    @Override
    public UserCodeWrapper<? extends T> getUserCodeWrapper() {
        return this.formatWrapper;
    }

    public String getStatisticsKey() {
        return this.statisticsKey;
    }

    public void setStatisticsKey(String statisticsKey) {
        this.statisticsKey = statisticsKey;
    }

    public void setSplitDataProperties(SplitDataProperties<OUT> splitDataProperties) {
        this.splitProperties = splitDataProperties;
    }

    public SplitDataProperties<OUT> getSplitDataProperties() {
        return this.splitProperties;
    }

    @Override
    public void accept(Visitor<Operator<?>> visitor) {
        if (visitor.preVisit(this)) {
            visitor.postVisit(this);
        }
    }

    protected List<OUT> executeOnCollections(RuntimeContext ctx, ExecutionConfig executionConfig) throws Exception {
        InputFormat inputFormat = (InputFormat)this.formatWrapper.getUserCodeObject();
        inputFormat.configure(this.parameters);
        if (inputFormat instanceof RichInputFormat) {
            ((RichInputFormat)inputFormat).setRuntimeContext(ctx);
            ((RichInputFormat)inputFormat).openInputFormat();
        }
        ArrayList result = new ArrayList();
        InputSplit[] splits = inputFormat.createInputSplits(1);
        TypeSerializer serializer = this.getOperatorInfo().getOutputType().createSerializer(executionConfig);
        for (InputSplit split : splits) {
            inputFormat.open(split);
            while (!inputFormat.reachedEnd()) {
                Object next = inputFormat.nextRecord(serializer.createInstance());
                if (next == null) continue;
                result.add(serializer.copy(next));
            }
            inputFormat.close();
        }
        if (inputFormat instanceof RichInputFormat) {
            ((RichInputFormat)inputFormat).closeInputFormat();
        }
        return result;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static interface SplitDataProperties<T> {
        public int[] getSplitPartitionKeys();

        public Partitioner<T> getSplitPartitioner();

        public int[] getSplitGroupKeys();

        public Ordering getSplitOrder();
    }
}

