/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.StateBinder;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.java.typeutils.MapTypeInfo;

@PublicEvolving
public class MapStateDescriptor<UK, UV>
extends StateDescriptor<MapState<UK, UV>, Map<UK, UV>> {
    private static final long serialVersionUID = 1L;

    public MapStateDescriptor(String name, TypeSerializer<UK> keySerializer, TypeSerializer<UV> valueSerializer) {
        super(name, new MapSerializer<UK, UV>(keySerializer, valueSerializer), null);
    }

    public MapStateDescriptor(String name, TypeInformation<UK> keyTypeInfo, TypeInformation<UV> valueTypeInfo) {
        super(name, new MapTypeInfo<UK, UV>(keyTypeInfo, valueTypeInfo), null);
    }

    public MapStateDescriptor(String name, Class<UK> keyClass, Class<UV> valueClass) {
        super(name, new MapTypeInfo<UK, UV>(keyClass, valueClass), null);
    }

    @Override
    public MapState<UK, UV> bind(StateBinder stateBinder) throws Exception {
        return stateBinder.createMapState(this);
    }

    @Override
    public StateDescriptor.Type getType() {
        return StateDescriptor.Type.MAP;
    }

    public TypeSerializer<UK> getKeySerializer() {
        TypeSerializer rawSerializer = this.getSerializer();
        if (!(rawSerializer instanceof MapSerializer)) {
            throw new IllegalStateException("Unexpected serializer type.");
        }
        return ((MapSerializer)rawSerializer).getKeySerializer();
    }

    public TypeSerializer<UV> getValueSerializer() {
        TypeSerializer rawSerializer = this.getSerializer();
        if (!(rawSerializer instanceof MapSerializer)) {
            throw new IllegalStateException("Unexpected serializer type.");
        }
        return ((MapSerializer)rawSerializer).getValueSerializer();
    }
}

