/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.StateBinder;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class ReducingStateDescriptor<T>
extends StateDescriptor<ReducingState<T>, T> {
    private static final long serialVersionUID = 1L;
    private final ReduceFunction<T> reduceFunction;

    public ReducingStateDescriptor(String name, ReduceFunction<T> reduceFunction, Class<T> typeClass) {
        super(name, typeClass, null);
        this.reduceFunction = Preconditions.checkNotNull(reduceFunction);
        if (reduceFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of ReducingState can not be a RichFunction.");
        }
    }

    public ReducingStateDescriptor(String name, ReduceFunction<T> reduceFunction, TypeInformation<T> typeInfo) {
        super(name, typeInfo, null);
        this.reduceFunction = Preconditions.checkNotNull(reduceFunction);
    }

    public ReducingStateDescriptor(String name, ReduceFunction<T> reduceFunction, TypeSerializer<T> typeSerializer) {
        super(name, typeSerializer, null);
        this.reduceFunction = Preconditions.checkNotNull(reduceFunction);
    }

    @Override
    public ReducingState<T> bind(StateBinder stateBinder) throws Exception {
        return stateBinder.createReducingState(this);
    }

    public ReduceFunction<T> getReduceFunction() {
        return this.reduceFunction;
    }

    @Override
    public StateDescriptor.Type getType() {
        return StateDescriptor.Type.REDUCING;
    }
}

