/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.BigDecimalTypeInfo;
import org.apache.flink.api.common.typeinfo.FractionalTypeInfo;
import org.apache.flink.api.common.typeinfo.IntegerTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.BigIntComparator;
import org.apache.flink.api.common.typeutils.base.BigIntSerializer;
import org.apache.flink.api.common.typeutils.base.BooleanComparator;
import org.apache.flink.api.common.typeutils.base.BooleanSerializer;
import org.apache.flink.api.common.typeutils.base.ByteComparator;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.api.common.typeutils.base.CharComparator;
import org.apache.flink.api.common.typeutils.base.CharSerializer;
import org.apache.flink.api.common.typeutils.base.DateComparator;
import org.apache.flink.api.common.typeutils.base.DateSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleComparator;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.FloatComparator;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongComparator;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.ShortComparator;
import org.apache.flink.api.common.typeutils.base.ShortSerializer;
import org.apache.flink.api.common.typeutils.base.StringComparator;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.common.typeutils.base.VoidSerializer;
import org.apache.flink.util.Preconditions;

@Public
public class BasicTypeInfo<T>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = -430955220409131770L;
    public static final BasicTypeInfo<String> STRING_TYPE_INFO = new BasicTypeInfo<String>(String.class, new Class[0], StringSerializer.INSTANCE, StringComparator.class);
    public static final BasicTypeInfo<Boolean> BOOLEAN_TYPE_INFO = new BasicTypeInfo<Boolean>(Boolean.class, new Class[0], BooleanSerializer.INSTANCE, BooleanComparator.class);
    public static final BasicTypeInfo<Byte> BYTE_TYPE_INFO = new IntegerTypeInfo<Byte>(Byte.class, new Class[]{Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class}, ByteSerializer.INSTANCE, ByteComparator.class);
    public static final BasicTypeInfo<Short> SHORT_TYPE_INFO = new IntegerTypeInfo<Short>(Short.class, new Class[]{Integer.class, Long.class, Float.class, Double.class, Character.class}, ShortSerializer.INSTANCE, ShortComparator.class);
    public static final BasicTypeInfo<Integer> INT_TYPE_INFO = new IntegerTypeInfo<Integer>(Integer.class, new Class[]{Long.class, Float.class, Double.class, Character.class}, IntSerializer.INSTANCE, IntComparator.class);
    public static final BasicTypeInfo<Long> LONG_TYPE_INFO = new IntegerTypeInfo<Long>(Long.class, new Class[]{Float.class, Double.class, Character.class}, LongSerializer.INSTANCE, LongComparator.class);
    public static final BasicTypeInfo<Float> FLOAT_TYPE_INFO = new FractionalTypeInfo<Float>(Float.class, new Class[]{Double.class}, FloatSerializer.INSTANCE, FloatComparator.class);
    public static final BasicTypeInfo<Double> DOUBLE_TYPE_INFO = new FractionalTypeInfo<Double>(Double.class, new Class[0], DoubleSerializer.INSTANCE, DoubleComparator.class);
    public static final BasicTypeInfo<Character> CHAR_TYPE_INFO = new BasicTypeInfo<Character>(Character.class, new Class[0], CharSerializer.INSTANCE, CharComparator.class);
    public static final BasicTypeInfo<Date> DATE_TYPE_INFO = new BasicTypeInfo<Date>(Date.class, new Class[0], DateSerializer.INSTANCE, DateComparator.class);
    public static final BasicTypeInfo<Void> VOID_TYPE_INFO = new BasicTypeInfo<Void>(Void.class, new Class[0], VoidSerializer.INSTANCE, null);
    public static final BasicTypeInfo<BigInteger> BIG_INT_TYPE_INFO = new BasicTypeInfo<BigInteger>(BigInteger.class, new Class[0], BigIntSerializer.INSTANCE, BigIntComparator.class);
    public static final BasicTypeInfo<BigDecimal> BIG_DEC_TYPE_INFO = new BigDecimalTypeInfo(38, 18);
    private final Class<T> clazz;
    private final TypeSerializer<T> serializer;
    private final Class<?>[] possibleCastTargetTypes;
    private final Class<? extends TypeComparator<T>> comparatorClass;
    private static final Map<Class<?>, BasicTypeInfo<?>> TYPES = new HashMap();

    protected BasicTypeInfo(Class<T> clazz, Class<?>[] possibleCastTargetTypes, TypeSerializer<T> serializer, Class<? extends TypeComparator<T>> comparatorClass) {
        this.clazz = Preconditions.checkNotNull(clazz);
        this.possibleCastTargetTypes = Preconditions.checkNotNull(possibleCastTargetTypes);
        this.serializer = Preconditions.checkNotNull(serializer);
        this.comparatorClass = comparatorClass;
    }

    @PublicEvolving
    public boolean shouldAutocastTo(BasicTypeInfo<?> to) {
        for (Class<?> possibleTo : this.possibleCastTargetTypes) {
            if (!possibleTo.equals(to.getTypeClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    @PublicEvolving
    public boolean isBasicType() {
        return true;
    }

    @Override
    @PublicEvolving
    public boolean isTupleType() {
        return false;
    }

    @Override
    @PublicEvolving
    public int getArity() {
        return 1;
    }

    @Override
    @PublicEvolving
    public int getTotalFields() {
        return 1;
    }

    @Override
    @PublicEvolving
    public Class<T> getTypeClass() {
        return this.clazz;
    }

    @Override
    @PublicEvolving
    public boolean isKeyType() {
        return true;
    }

    @Override
    @PublicEvolving
    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        return this.serializer;
    }

    @Override
    @PublicEvolving
    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        if (this.comparatorClass != null) {
            return BasicTypeInfo.instantiateComparator(this.comparatorClass, sortOrderAscending);
        }
        throw new InvalidTypesException("The type " + this.clazz.getSimpleName() + " cannot be used as a key.");
    }

    @Override
    public int hashCode() {
        return 31 * Objects.hash(this.clazz, this.serializer, this.comparatorClass) + Arrays.hashCode(this.possibleCastTargetTypes);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BasicTypeInfo;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BasicTypeInfo) {
            BasicTypeInfo other = (BasicTypeInfo)obj;
            return other.canEqual(this) && this.clazz == other.clazz && this.serializer.equals(other.serializer) && this.comparatorClass == other.comparatorClass;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.clazz.getSimpleName();
    }

    @PublicEvolving
    public static <X> BasicTypeInfo<X> getInfoFor(Class<X> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        BasicTypeInfo<?> info = TYPES.get(type);
        return info;
    }

    private static <X> TypeComparator<X> instantiateComparator(Class<? extends TypeComparator<X>> comparatorClass, boolean ascendingOrder) {
        try {
            Constructor<TypeComparator<X>> constructor = comparatorClass.getConstructor(Boolean.TYPE);
            return constructor.newInstance(ascendingOrder);
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not initialize basic comparator " + comparatorClass.getName(), e2);
        }
    }

    static {
        TYPES.put(String.class, STRING_TYPE_INFO);
        TYPES.put(Boolean.class, BOOLEAN_TYPE_INFO);
        TYPES.put(Boolean.TYPE, BOOLEAN_TYPE_INFO);
        TYPES.put(Byte.class, BYTE_TYPE_INFO);
        TYPES.put(Byte.TYPE, BYTE_TYPE_INFO);
        TYPES.put(Short.class, SHORT_TYPE_INFO);
        TYPES.put(Short.TYPE, SHORT_TYPE_INFO);
        TYPES.put(Integer.class, INT_TYPE_INFO);
        TYPES.put(Integer.TYPE, INT_TYPE_INFO);
        TYPES.put(Long.class, LONG_TYPE_INFO);
        TYPES.put(Long.TYPE, LONG_TYPE_INFO);
        TYPES.put(Float.class, FLOAT_TYPE_INFO);
        TYPES.put(Float.TYPE, FLOAT_TYPE_INFO);
        TYPES.put(Double.class, DOUBLE_TYPE_INFO);
        TYPES.put(Double.TYPE, DOUBLE_TYPE_INFO);
        TYPES.put(Character.class, CHAR_TYPE_INFO);
        TYPES.put(Character.TYPE, CHAR_TYPE_INFO);
        TYPES.put(Date.class, DATE_TYPE_INFO);
        TYPES.put(Void.class, VOID_TYPE_INFO);
        TYPES.put(Void.TYPE, VOID_TYPE_INFO);
        TYPES.put(BigInteger.class, BIG_INT_TYPE_INFO);
        TYPES.put(BigDecimal.class, BIG_DEC_TYPE_INFO);
    }
}

