/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.functions.Comparator;
import org.apache.flink.api.common.typeutils.SerializationException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.Preconditions;

public class BytewiseComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = -854039422114672899L;
    public static final BytewiseComparator<byte[]> BYTEARRAY_INSTANCE = new BytewiseComparator<byte[]>(ComparableByteArraySerializer.INSTANCE);
    public static final BytewiseComparator<Byte> BYTE_INSTANCE = new BytewiseComparator<Byte>(ByteSerializer.INSTANCE);
    public static final BytewiseComparator<Integer> INT_INSTANCE = new BytewiseComparator<Integer>(IntSerializer.INSTANCE);
    public static final BytewiseComparator<Long> LONG_INSTANCE = new BytewiseComparator<Long>(LongSerializer.INSTANCE);
    public static final BytewiseComparator<Float> FLOAT_INSTANCE = new BytewiseComparator<Float>(FloatSerializer.INSTANCE);
    public static final BytewiseComparator<Double> DOUBLE_INSTANCE = new BytewiseComparator<Double>(DoubleSerializer.INSTANCE);
    private final TypeSerializer<T> serializer;

    public BytewiseComparator(TypeSerializer<T> serializer) {
        this.serializer = Preconditions.checkNotNull(serializer, "The serializer cannot be null.");
    }

    public static int compareBytes(byte[] leftBytes, byte[] rightBytes) {
        return BytewiseComparator.compareBytes(leftBytes, 0, leftBytes.length, rightBytes, 0, rightBytes.length);
    }

    public static int compareBytes(byte[] leftBytes, int leftOffset, int leftLength, byte[] rightBytes, int rightOffset, int rightLength) {
        int length = Math.min(leftLength, rightLength);
        for (int i = 0; i < length; ++i) {
            if (leftBytes[leftOffset + i] == rightBytes[rightOffset + i]) continue;
            return (leftBytes[leftOffset + i] & 0xFF) - (rightBytes[rightOffset + i] & 0xFF);
        }
        return leftLength - rightLength;
    }

    public TypeSerializer<T> getSerializer() {
        return this.serializer;
    }

    @Override
    public int compare(T left, T right) {
        ByteArrayOutputStreamWithPos outputStream = new ByteArrayOutputStreamWithPos();
        DataOutputViewStreamWrapper outputView = new DataOutputViewStreamWrapper(outputStream);
        try {
            this.serializer.serialize(left, outputView);
            byte[] leftBytes = outputStream.toByteArray();
            outputStream.reset();
            this.serializer.serialize(right, outputView);
            byte[] rightBytes = outputStream.toByteArray();
            return BytewiseComparator.compareBytes(leftBytes, rightBytes);
        }
        catch (IOException e2) {
            throw new SerializationException(e2);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return ((BytewiseComparator)o).serializer.equals(this.serializer);
    }

    public String toString() {
        return "BytewiseComparator(" + this.serializer.toString() + ")";
    }

    private static class ComparableByteArraySerializer
    extends TypeSerializerSingleton<byte[]> {
        static final ComparableByteArraySerializer INSTANCE = new ComparableByteArraySerializer();

        private ComparableByteArraySerializer() {
        }

        @Override
        public boolean isImmutableType() {
            return false;
        }

        @Override
        public byte[] createInstance() {
            return new byte[0];
        }

        @Override
        public byte[] copy(byte[] from) {
            byte[] to = new byte[from.length];
            System.arraycopy(from, 0, to, 0, from.length);
            return to;
        }

        @Override
        public byte[] copy(byte[] from, byte[] reuse) {
            return this.copy(from);
        }

        @Override
        public int getLength() {
            return -1;
        }

        @Override
        public void serialize(byte[] record, DataOutputView target) throws IOException {
            if (record == null) {
                throw new IllegalArgumentException("The record must not be null.");
            }
            target.skipBytesToWrite(1);
            target.write(record);
        }

        @Override
        public byte[] deserialize(DataInputView source) throws IOException {
            int numBytes;
            ByteArrayOutputStreamWithPos output2 = new ByteArrayOutputStreamWithPos();
            byte[] buffer = new byte[1024];
            source.skipBytesToRead(1);
            while ((numBytes = source.read(buffer)) != -1) {
                output2.write(buffer, 0, numBytes);
            }
            return output2.toByteArray();
        }

        @Override
        public byte[] deserialize(byte[] reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        @Override
        public void copy(DataInputView source, DataOutputView target) throws IOException {
            int numBytes;
            byte[] buffer = new byte[1024];
            while ((numBytes = source.read(buffer)) != -1) {
                target.write(buffer, 0, numBytes);
            }
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || obj instanceof ComparableByteArraySerializer;
        }

        @Override
        public boolean canEqual(Object obj) {
            return obj instanceof ComparableByteArraySerializer;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }

        public String toString() {
            return "ComparableByteArraySerializer";
        }
    }
}

