/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.api.common.typeutils.base.ComparatorUtil;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class ByteComparator
extends BasicTypeComparator<Byte> {
    private static final long serialVersionUID = 1L;

    public ByteComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        byte b2;
        byte b1 = firstSource.readByte();
        int comp = b1 < (b2 = secondSource.readByte()) ? -1 : (b1 == b2 ? 0 : 1);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 1;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 1;
    }

    @Override
    public void putNormalizedKey(Byte value, MemorySegment target, int offset, int numBytes) {
        ComparatorUtil.putByteNormalizedKey(value, target, offset, numBytes);
    }

    public ByteComparator duplicate() {
        return new ByteComparator(this.ascendingComparison);
    }
}

