/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.CharValueSerializer;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class CharSerializer
extends TypeSerializerSingleton<Character> {
    private static final long serialVersionUID = 1L;
    public static final CharSerializer INSTANCE = new CharSerializer();
    private static final Character ZERO = Character.valueOf('\u0000');

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Character createInstance() {
        return ZERO;
    }

    @Override
    public Character copy(Character from) {
        return from;
    }

    @Override
    public Character copy(Character from, Character reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public void serialize(Character record, DataOutputView target) throws IOException {
        target.writeChar(record.charValue());
    }

    @Override
    public Character deserialize(DataInputView source) throws IOException {
        return Character.valueOf(source.readChar());
    }

    @Override
    public Character deserialize(Character reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeChar(source.readChar());
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof CharSerializer;
    }

    @Override
    protected boolean isCompatibleSerializationFormatIdentifier(String identifier) {
        return super.isCompatibleSerializationFormatIdentifier(identifier) || identifier.equals(CharValueSerializer.class.getCanonicalName());
    }
}

