/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.TypeDeserializerAdapter;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.common.typeutils.base.CollectionSerializerConfigSnapshot;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public final class ListSerializer<T>
extends TypeSerializer<List<T>> {
    private static final long serialVersionUID = 1119562170939152304L;
    private final TypeSerializer<T> elementSerializer;

    public ListSerializer(TypeSerializer<T> elementSerializer) {
        this.elementSerializer = Preconditions.checkNotNull(elementSerializer);
    }

    public TypeSerializer<T> getElementSerializer() {
        return this.elementSerializer;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<List<T>> duplicate() {
        TypeSerializer<T> duplicateElement = this.elementSerializer.duplicate();
        return duplicateElement == this.elementSerializer ? this : new ListSerializer<T>(duplicateElement);
    }

    @Override
    public List<T> createInstance() {
        return new ArrayList(0);
    }

    @Override
    public List<T> copy(List<T> from) {
        ArrayList<T> newList = new ArrayList<T>(from.size());
        for (T element : from) {
            newList.add(this.elementSerializer.copy(element));
        }
        return newList;
    }

    @Override
    public List<T> copy(List<T> from, List<T> reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(List<T> list, DataOutputView target) throws IOException {
        int size = list.size();
        target.writeInt(size);
        for (T element : list) {
            this.elementSerializer.serialize(element, target);
        }
    }

    @Override
    public List<T> deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        ArrayList<T> list = new ArrayList<T>(size + 1);
        for (int i = 0; i < size; ++i) {
            list.add(this.elementSerializer.deserialize(source));
        }
        return list;
    }

    @Override
    public List<T> deserialize(List<T> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int num = source.readInt();
        target.writeInt(num);
        for (int i = 0; i < num; ++i) {
            this.elementSerializer.copy(source, target);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.elementSerializer.equals(((ListSerializer)obj).elementSerializer);
    }

    @Override
    public boolean canEqual(Object obj) {
        return true;
    }

    @Override
    public int hashCode() {
        return this.elementSerializer.hashCode();
    }

    @Override
    public CollectionSerializerConfigSnapshot snapshotConfiguration() {
        return new CollectionSerializerConfigSnapshot<T>(this.elementSerializer);
    }

    @Override
    public CompatibilityResult<List<T>> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof CollectionSerializerConfigSnapshot) {
            Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot> previousElemSerializerAndConfig = ((CollectionSerializerConfigSnapshot)configSnapshot).getSingleNestedSerializerAndConfig();
            CompatibilityResult<T> compatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)previousElemSerializerAndConfig.f0, UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)previousElemSerializerAndConfig.f1, this.elementSerializer);
            if (!compatResult.isRequiresMigration()) {
                return CompatibilityResult.compatible();
            }
            if (compatResult.getConvertDeserializer() != null) {
                return CompatibilityResult.requiresMigration(new ListSerializer<T>(new TypeDeserializerAdapter<T>(compatResult.getConvertDeserializer())));
            }
        }
        return CompatibilityResult.requiresMigration();
    }
}

