/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInfoFactory;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple0;
import org.apache.flink.api.java.typeutils.AvroUtils;
import org.apache.flink.api.java.typeutils.EnumTypeInfo;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractionException;
import org.apache.flink.api.java.typeutils.TypeExtractionUtils;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.types.Value;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class TypeExtractor {
    private static final String HADOOP_WRITABLE_CLASS = "org.apache.hadoop.io.Writable";
    private static final String HADOOP_WRITABLE_TYPEINFO_CLASS = "org.apache.flink.api.java.typeutils.WritableTypeInfo";
    private static final String AVRO_SPECIFIC_RECORD_BASE_CLASS = "org.apache.avro.specific.SpecificRecordBase";
    private static final Logger LOG = LoggerFactory.getLogger(TypeExtractor.class);
    public static final int[] NO_INDEX = new int[0];
    private static Map<Type, Class<? extends TypeInfoFactory>> registeredTypeInfoFactories = new HashMap<Type, Class<? extends TypeInfoFactory>>();

    protected TypeExtractor() {
    }

    private static void registerFactory(Type t, Class<? extends TypeInfoFactory> factory) {
        Preconditions.checkNotNull(t, "Type parameter must not be null.");
        Preconditions.checkNotNull(factory, "Factory parameter must not be null.");
        if (!TypeInfoFactory.class.isAssignableFrom(factory)) {
            throw new IllegalArgumentException("Class is not a TypeInfoFactory.");
        }
        if (registeredTypeInfoFactories.containsKey(t)) {
            throw new InvalidTypesException("A TypeInfoFactory for type '" + t + "' is already registered.");
        }
        registeredTypeInfoFactories.put(t, factory);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getMapReturnTypes(MapFunction<IN, OUT> mapInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getMapReturnTypes(mapInterface, inType, null, false);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getMapReturnTypes(MapFunction<IN, OUT> mapInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(mapInterface, MapFunction.class, 0, 1, NO_INDEX, inType, functionName, allowMissing);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getFlatMapReturnTypes(FlatMapFunction<IN, OUT> flatMapInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getFlatMapReturnTypes(flatMapInterface, inType, null, false);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getFlatMapReturnTypes(FlatMapFunction<IN, OUT> flatMapInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(flatMapInterface, FlatMapFunction.class, 0, 1, new int[]{1, 0}, inType, functionName, allowMissing);
    }

    @Deprecated
    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getFoldReturnTypes(FoldFunction<IN, OUT> foldInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getFoldReturnTypes(foldInterface, inType, null, false);
    }

    @Deprecated
    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getFoldReturnTypes(FoldFunction<IN, OUT> foldInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(foldInterface, FoldFunction.class, 0, 1, NO_INDEX, inType, functionName, allowMissing);
    }

    @PublicEvolving
    public static <IN, ACC> TypeInformation<ACC> getAggregateFunctionAccumulatorType(AggregateFunction<IN, ACC, ?> function, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(function, AggregateFunction.class, 0, 1, NO_INDEX, inType, functionName, allowMissing);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getAggregateFunctionReturnType(AggregateFunction<IN, ?, OUT> function, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(function, AggregateFunction.class, 0, 2, NO_INDEX, inType, functionName, allowMissing);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getMapPartitionReturnTypes(MapPartitionFunction<IN, OUT> mapPartitionInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getMapPartitionReturnTypes(mapPartitionInterface, inType, null, false);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getMapPartitionReturnTypes(MapPartitionFunction<IN, OUT> mapPartitionInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(mapPartitionInterface, MapPartitionFunction.class, 0, 1, new int[]{1, 0}, inType, functionName, allowMissing);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getGroupReduceReturnTypes(GroupReduceFunction<IN, OUT> groupReduceInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getGroupReduceReturnTypes(groupReduceInterface, inType, null, false);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getGroupReduceReturnTypes(GroupReduceFunction<IN, OUT> groupReduceInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(groupReduceInterface, GroupReduceFunction.class, 0, 1, new int[]{1, 0}, inType, functionName, allowMissing);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getGroupCombineReturnTypes(GroupCombineFunction<IN, OUT> combineInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getGroupCombineReturnTypes(combineInterface, inType, null, false);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getGroupCombineReturnTypes(GroupCombineFunction<IN, OUT> combineInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(combineInterface, GroupCombineFunction.class, 0, 1, new int[]{1, 0}, inType, functionName, allowMissing);
    }

    @PublicEvolving
    public static <IN1, IN2, OUT> TypeInformation<OUT> getFlatJoinReturnTypes(FlatJoinFunction<IN1, IN2, OUT> joinInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        return TypeExtractor.getFlatJoinReturnTypes(joinInterface, in1Type, in2Type, null, false);
    }

    @PublicEvolving
    public static <IN1, IN2, OUT> TypeInformation<OUT> getFlatJoinReturnTypes(FlatJoinFunction<IN1, IN2, OUT> joinInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type, String functionName, boolean allowMissing) {
        return TypeExtractor.getBinaryOperatorReturnType(joinInterface, FlatJoinFunction.class, 0, 1, 2, new int[]{2, 0}, in1Type, in2Type, functionName, allowMissing);
    }

    @PublicEvolving
    public static <IN1, IN2, OUT> TypeInformation<OUT> getJoinReturnTypes(JoinFunction<IN1, IN2, OUT> joinInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        return TypeExtractor.getJoinReturnTypes(joinInterface, in1Type, in2Type, null, false);
    }

    @PublicEvolving
    public static <IN1, IN2, OUT> TypeInformation<OUT> getJoinReturnTypes(JoinFunction<IN1, IN2, OUT> joinInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type, String functionName, boolean allowMissing) {
        return TypeExtractor.getBinaryOperatorReturnType(joinInterface, JoinFunction.class, 0, 1, 2, NO_INDEX, in1Type, in2Type, functionName, allowMissing);
    }

    @PublicEvolving
    public static <IN1, IN2, OUT> TypeInformation<OUT> getCoGroupReturnTypes(CoGroupFunction<IN1, IN2, OUT> coGroupInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        return TypeExtractor.getCoGroupReturnTypes(coGroupInterface, in1Type, in2Type, null, false);
    }

    @PublicEvolving
    public static <IN1, IN2, OUT> TypeInformation<OUT> getCoGroupReturnTypes(CoGroupFunction<IN1, IN2, OUT> coGroupInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type, String functionName, boolean allowMissing) {
        return TypeExtractor.getBinaryOperatorReturnType(coGroupInterface, CoGroupFunction.class, 0, 1, 2, new int[]{2, 0}, in1Type, in2Type, functionName, allowMissing);
    }

    @PublicEvolving
    public static <IN1, IN2, OUT> TypeInformation<OUT> getCrossReturnTypes(CrossFunction<IN1, IN2, OUT> crossInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        return TypeExtractor.getCrossReturnTypes(crossInterface, in1Type, in2Type, null, false);
    }

    @PublicEvolving
    public static <IN1, IN2, OUT> TypeInformation<OUT> getCrossReturnTypes(CrossFunction<IN1, IN2, OUT> crossInterface, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type, String functionName, boolean allowMissing) {
        return TypeExtractor.getBinaryOperatorReturnType(crossInterface, CrossFunction.class, 0, 1, 2, NO_INDEX, in1Type, in2Type, functionName, allowMissing);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getKeySelectorTypes(KeySelector<IN, OUT> selectorInterface, TypeInformation<IN> inType) {
        return TypeExtractor.getKeySelectorTypes(selectorInterface, inType, null, false);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getKeySelectorTypes(KeySelector<IN, OUT> selectorInterface, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(selectorInterface, KeySelector.class, 0, 1, NO_INDEX, inType, functionName, allowMissing);
    }

    @PublicEvolving
    public static <T> TypeInformation<T> getPartitionerTypes(Partitioner<T> partitioner) {
        return TypeExtractor.getPartitionerTypes(partitioner, null, false);
    }

    @PublicEvolving
    public static <T> TypeInformation<T> getPartitionerTypes(Partitioner<T> partitioner, String functionName, boolean allowMissing) {
        return TypeExtractor.getUnaryOperatorReturnType(partitioner, Partitioner.class, -1, 0, new int[]{0}, null, functionName, allowMissing);
    }

    @PublicEvolving
    public static <IN> TypeInformation<IN> getInputFormatTypes(InputFormat<IN, ?> inputFormatInterface) {
        if (inputFormatInterface instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)((Object)inputFormatInterface)).getProducedType();
        }
        return new TypeExtractor().privateCreateTypeInfo(InputFormat.class, inputFormatInterface.getClass(), 0, null, null);
    }

    @PublicEvolving
    public static <IN, OUT> TypeInformation<OUT> getUnaryOperatorReturnType(Function function, Class<?> baseClass, int inputTypeArgumentIndex, int outputTypeArgumentIndex, int[] lambdaOutputTypeArgumentIndices, TypeInformation<IN> inType, String functionName, boolean allowMissing) {
        Preconditions.checkArgument(inType == null || inputTypeArgumentIndex >= 0, "Input type argument index was not provided");
        Preconditions.checkArgument(outputTypeArgumentIndex >= 0, "Output type argument index was not provided");
        Preconditions.checkArgument(lambdaOutputTypeArgumentIndices != null, "Indices for output type arguments within lambda not provided");
        if (function instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)((Object)function)).getProducedType();
        }
        try {
            TypeExtractionUtils.LambdaExecutable exec;
            try {
                exec = TypeExtractionUtils.checkAndExtractLambda(function);
            }
            catch (TypeExtractionException e2) {
                throw new InvalidTypesException("Internal error occurred.", e2);
            }
            if (exec != null) {
                Type output2;
                int paramLen = exec.getParameterTypes().length;
                Method sam = TypeExtractionUtils.getSingleAbstractMethod(baseClass);
                int baseParametersLen = sam.getParameterTypes().length;
                if (lambdaOutputTypeArgumentIndices.length > 0) {
                    output2 = TypeExtractionUtils.extractTypeFromLambda(baseClass, exec, lambdaOutputTypeArgumentIndices, paramLen, baseParametersLen);
                } else {
                    output2 = exec.getReturnType();
                    TypeExtractionUtils.validateLambdaType(baseClass, output2);
                }
                return new TypeExtractor().privateCreateTypeInfo(output2, inType, null);
            }
            if (inType != null) {
                TypeExtractor.validateInputType(baseClass, function.getClass(), inputTypeArgumentIndex, inType);
            }
            return new TypeExtractor().privateCreateTypeInfo(baseClass, function.getClass(), outputTypeArgumentIndex, inType, null);
        }
        catch (InvalidTypesException e3) {
            if (allowMissing) {
                return new MissingTypeInfo(functionName != null ? functionName : function.toString(), e3);
            }
            throw e3;
        }
    }

    @PublicEvolving
    public static <IN1, IN2, OUT> TypeInformation<OUT> getBinaryOperatorReturnType(Function function, Class<?> baseClass, int input1TypeArgumentIndex, int input2TypeArgumentIndex, int outputTypeArgumentIndex, int[] lambdaOutputTypeArgumentIndices, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type, String functionName, boolean allowMissing) {
        Preconditions.checkArgument(in1Type == null || input1TypeArgumentIndex >= 0, "Input 1 type argument index was not provided");
        Preconditions.checkArgument(in2Type == null || input2TypeArgumentIndex >= 0, "Input 2 type argument index was not provided");
        Preconditions.checkArgument(outputTypeArgumentIndex >= 0, "Output type argument index was not provided");
        Preconditions.checkArgument(lambdaOutputTypeArgumentIndices != null, "Indices for output type arguments within lambda not provided");
        if (function instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)((Object)function)).getProducedType();
        }
        try {
            TypeExtractionUtils.LambdaExecutable exec;
            try {
                exec = TypeExtractionUtils.checkAndExtractLambda(function);
            }
            catch (TypeExtractionException e2) {
                throw new InvalidTypesException("Internal error occurred.", e2);
            }
            if (exec != null) {
                Type output2;
                Method sam = TypeExtractionUtils.getSingleAbstractMethod(baseClass);
                int baseParametersLen = sam.getParameterTypes().length;
                int paramLen = exec.getParameterTypes().length;
                if (lambdaOutputTypeArgumentIndices.length > 0) {
                    output2 = TypeExtractionUtils.extractTypeFromLambda(baseClass, exec, lambdaOutputTypeArgumentIndices, paramLen, baseParametersLen);
                } else {
                    output2 = exec.getReturnType();
                    TypeExtractionUtils.validateLambdaType(baseClass, output2);
                }
                return new TypeExtractor().privateCreateTypeInfo(output2, in1Type, in2Type);
            }
            if (in1Type != null) {
                TypeExtractor.validateInputType(baseClass, function.getClass(), input1TypeArgumentIndex, in1Type);
            }
            if (in2Type != null) {
                TypeExtractor.validateInputType(baseClass, function.getClass(), input2TypeArgumentIndex, in2Type);
            }
            return new TypeExtractor().privateCreateTypeInfo(baseClass, function.getClass(), outputTypeArgumentIndex, in1Type, in2Type);
        }
        catch (InvalidTypesException e3) {
            if (allowMissing) {
                return new MissingTypeInfo(functionName != null ? functionName : function.toString(), e3);
            }
            throw e3;
        }
    }

    public static <T> TypeInformation<T> createTypeInfo(Class<T> type) {
        return TypeExtractor.createTypeInfo(type);
    }

    public static TypeInformation<?> createTypeInfo(Type t) {
        TypeInformation<?> ti = new TypeExtractor().privateCreateTypeInfo(t);
        if (ti == null) {
            throw new InvalidTypesException("Could not extract type information.");
        }
        return ti;
    }

    @PublicEvolving
    public static <OUT> TypeInformation<OUT> createTypeInfo(Object instance, Class<?> baseClass, Class<?> clazz, int returnParamPos) {
        if (instance instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)instance).getProducedType();
        }
        return TypeExtractor.createTypeInfo(baseClass, clazz, returnParamPos, null, null);
    }

    @PublicEvolving
    public static <IN1, IN2, OUT> TypeInformation<OUT> createTypeInfo(Class<?> baseClass, Class<?> clazz, int returnParamPos, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        TypeInformation<OUT> ti = new TypeExtractor().privateCreateTypeInfo(baseClass, clazz, returnParamPos, in1Type, in2Type);
        if (ti == null) {
            throw new InvalidTypesException("Could not extract type information.");
        }
        return ti;
    }

    private TypeInformation<?> privateCreateTypeInfo(Type t) {
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        typeHierarchy.add(t);
        return this.createTypeInfoWithTypeHierarchy(typeHierarchy, t, null, null);
    }

    private <IN1, IN2, OUT> TypeInformation<OUT> privateCreateTypeInfo(Class<?> baseClass, Class<?> clazz, int returnParamPos, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        TypeInformation<?> typeInfo;
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        Type returnType2 = TypeExtractor.getParameterType(baseClass, typeHierarchy, clazz, returnParamPos);
        if (returnType2 instanceof TypeVariable && (typeInfo = this.createTypeInfoFromInputs((TypeVariable)returnType2, typeHierarchy, in1Type, in2Type)) != null) {
            return typeInfo;
        }
        return this.createTypeInfoWithTypeHierarchy(typeHierarchy, returnType2, in1Type, in2Type);
    }

    private <IN1, IN2, OUT> TypeInformation<OUT> privateCreateTypeInfo(Type returnType2, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        return this.createTypeInfoWithTypeHierarchy(typeHierarchy, returnType2, in1Type, in2Type);
    }

    private <IN1, IN2, OUT> TypeInformation<OUT> createTypeInfoWithTypeHierarchy(ArrayList<Type> typeHierarchy, Type t, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        TypeInformation<OUT> typeFromFactory = this.createTypeInfoFromFactory(t, typeHierarchy, in1Type, in2Type);
        if (typeFromFactory != null) {
            return typeFromFactory;
        }
        if (TypeExtractionUtils.isClassType(t) && Tuple.class.isAssignableFrom(TypeExtractionUtils.typeToClass(t))) {
            Type curT = t;
            if (TypeExtractionUtils.typeToClass(t).equals(Tuple.class)) {
                throw new InvalidTypesException("Usage of class Tuple as a type is not allowed. Use a concrete subclass (e.g. Tuple1, Tuple2, etc.) instead.");
            }
            while (!TypeExtractionUtils.isClassType(curT) || !TypeExtractionUtils.typeToClass(curT).getSuperclass().equals(Tuple.class)) {
                typeHierarchy.add(curT);
                curT = TypeExtractionUtils.typeToClass(curT).getGenericSuperclass();
            }
            if (curT == Tuple0.class) {
                return new TupleTypeInfo<Tuple0>(Tuple0.class, new TypeInformation[0]);
            }
            if (curT instanceof Class) {
                throw new InvalidTypesException("Tuple needs to be parameterized by using generics.");
            }
            typeHierarchy.add(curT);
            TypeInformation<?>[] subTypesInfo = this.createSubTypesInfo(t, (ParameterizedType)curT, typeHierarchy, in1Type, in2Type, false);
            if (subTypesInfo == null) {
                if (t instanceof ParameterizedType) {
                    return this.analyzePojo(TypeExtractionUtils.typeToClass(t), new ArrayList<Type>(typeHierarchy), (ParameterizedType)t, in1Type, in2Type);
                }
                return this.analyzePojo(TypeExtractionUtils.typeToClass(t), new ArrayList<Type>(typeHierarchy), null, in1Type, in2Type);
            }
            return new TupleTypeInfo(TypeExtractionUtils.typeToClass(t), subTypesInfo);
        }
        if (t instanceof TypeVariable) {
            Type typeVar = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)t);
            if (!(typeVar instanceof TypeVariable)) {
                return this.createTypeInfoWithTypeHierarchy(typeHierarchy, typeVar, in1Type, in2Type);
            }
            TypeInformation<?> typeInfo = this.createTypeInfoFromInputs((TypeVariable)t, typeHierarchy, in1Type, in2Type);
            if (typeInfo != null) {
                return typeInfo;
            }
            throw new InvalidTypesException("Type of TypeVariable '" + ((TypeVariable)t).getName() + "' in '" + ((TypeVariable)t).getGenericDeclaration() + "' could not be determined. This is most likely a type erasure problem. The type extraction currently supports types with generic variables only in cases where all variables in the return type can be deduced from the input type(s). Otherwise the type has to be specified explicitly using type information.");
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType genericArray = (GenericArrayType)t;
            Type componentType = genericArray.getGenericComponentType();
            if (componentType instanceof Class) {
                Class componentClass = (Class)componentType;
                Class<?> classArray = Array.newInstance(componentClass, 0).getClass();
                return TypeExtractor.getForClass(classArray);
            }
            TypeInformation<OUT> componentInfo = this.createTypeInfoWithTypeHierarchy(typeHierarchy, genericArray.getGenericComponentType(), in1Type, in2Type);
            Class<OUT> componentClass = componentInfo.getTypeClass();
            Class<?> classArray = Array.newInstance(componentClass, 0).getClass();
            return ObjectArrayTypeInfo.getInfoFor(classArray, componentInfo);
        }
        if (t instanceof ParameterizedType) {
            return this.privateGetForClass(TypeExtractionUtils.typeToClass(t), typeHierarchy, (ParameterizedType)t, in1Type, in2Type);
        }
        if (t instanceof Class) {
            return this.privateGetForClass((Class)t, typeHierarchy);
        }
        throw new InvalidTypesException("Type Information could not be created.");
    }

    private <IN1, IN2> TypeInformation<?> createTypeInfoFromInputs(TypeVariable<?> returnTypeVar, ArrayList<Type> returnTypeHierarchy, TypeInformation<IN1> in1TypeInfo, TypeInformation<IN2> in2TypeInfo) {
        Type matReturnTypeVar = TypeExtractor.materializeTypeVariable(returnTypeHierarchy, returnTypeVar);
        if (!(matReturnTypeVar instanceof TypeVariable)) {
            return this.createTypeInfoWithTypeHierarchy(returnTypeHierarchy, matReturnTypeVar, in1TypeInfo, in2TypeInfo);
        }
        returnTypeVar = (TypeVariable)matReturnTypeVar;
        if (in1TypeInfo == null && in2TypeInfo == null) {
            return null;
        }
        ArrayList<Type> inputTypeHierarchy = new ArrayList<Type>();
        for (Type t : returnTypeHierarchy) {
            if (!TypeExtractionUtils.isClassType(t) || !Function.class.isAssignableFrom(TypeExtractionUtils.typeToClass(t)) || TypeExtractionUtils.typeToClass(t) == Function.class) break;
            inputTypeHierarchy.add(t);
        }
        ParameterizedType baseClass = (ParameterizedType)inputTypeHierarchy.get(inputTypeHierarchy.size() - 1);
        TypeInformation<?> info = null;
        if (in1TypeInfo != null) {
            Type in1Type = baseClass.getActualTypeArguments()[0];
            info = this.createTypeInfoFromInput(returnTypeVar, new ArrayList<Type>(inputTypeHierarchy), in1Type, in1TypeInfo);
        }
        if (info == null && in2TypeInfo != null) {
            Type in2Type = baseClass.getActualTypeArguments()[1];
            info = this.createTypeInfoFromInput(returnTypeVar, new ArrayList<Type>(inputTypeHierarchy), in2Type, in2TypeInfo);
        }
        if (info != null) {
            return info;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <IN1> TypeInformation<?> createTypeInfoFromInput(TypeVariable<?> returnTypeVar, ArrayList<Type> inputTypeHierarchy, Type inType, TypeInformation<IN1> inTypeInfo) {
        TypeInformation<?> info = null;
        ArrayList<Type> factoryHierarchy = new ArrayList<Type>(inputTypeHierarchy);
        TypeInfoFactory factory = TypeExtractor.getClosestFactory(factoryHierarchy, inType);
        if (factory != null) {
            Type factoryDefiningType = factoryHierarchy.get(factoryHierarchy.size() - 1);
            if (!(factoryDefiningType instanceof ParameterizedType)) return info;
            TypeVariable<Class<?>>[] typeParams = TypeExtractionUtils.typeToClass(factoryDefiningType).getTypeParameters();
            Type[] actualParams = ((ParameterizedType)factoryDefiningType).getActualTypeArguments();
            int i = 0;
            while (i < actualParams.length) {
                String typeParamName;
                Map<String, TypeInformation<?>> componentInfo = inTypeInfo.getGenericParameters();
                if (!componentInfo.containsKey(typeParamName = typeParams[i].toString())) throw new InvalidTypesException("TypeInformation '" + inTypeInfo.getClass().getSimpleName() + "' does not supply a mapping of TypeVariable '" + typeParamName + "' to corresponding TypeInformation. Input type inference can only produce a result with this information. Please implement method 'TypeInformation.getGenericParameters()' for this.");
                if (componentInfo.get(typeParamName) == null) {
                    throw new InvalidTypesException("TypeInformation '" + inTypeInfo.getClass().getSimpleName() + "' does not supply a mapping of TypeVariable '" + typeParamName + "' to corresponding TypeInformation. Input type inference can only produce a result with this information. Please implement method 'TypeInformation.getGenericParameters()' for this.");
                }
                info = this.createTypeInfoFromInput(returnTypeVar, factoryHierarchy, actualParams[i], componentInfo.get(typeParamName));
                if (info != null) return info;
                ++i;
            }
            return info;
        }
        if (TypeExtractionUtils.sameTypeVars(inType, returnTypeVar)) {
            return inTypeInfo;
        }
        if (inType instanceof TypeVariable) {
            Type resolvedInType = TypeExtractor.materializeTypeVariable(inputTypeHierarchy, (TypeVariable)inType);
            if (resolvedInType == inType) return info;
            return this.createTypeInfoFromInput(returnTypeVar, inputTypeHierarchy, resolvedInType, inTypeInfo);
        }
        if (inType instanceof GenericArrayType) {
            TypeInformation componentInfo = null;
            if (inTypeInfo instanceof BasicArrayTypeInfo) {
                componentInfo = ((BasicArrayTypeInfo)inTypeInfo).getComponentInfo();
                return this.createTypeInfoFromInput(returnTypeVar, inputTypeHierarchy, ((GenericArrayType)inType).getGenericComponentType(), componentInfo);
            } else if (inTypeInfo instanceof PrimitiveArrayTypeInfo) {
                componentInfo = BasicTypeInfo.getInfoFor(inTypeInfo.getTypeClass().getComponentType());
                return this.createTypeInfoFromInput(returnTypeVar, inputTypeHierarchy, ((GenericArrayType)inType).getGenericComponentType(), componentInfo);
            } else {
                if (!(inTypeInfo instanceof ObjectArrayTypeInfo)) return this.createTypeInfoFromInput(returnTypeVar, inputTypeHierarchy, ((GenericArrayType)inType).getGenericComponentType(), componentInfo);
                componentInfo = ((ObjectArrayTypeInfo)inTypeInfo).getComponentInfo();
            }
            return this.createTypeInfoFromInput(returnTypeVar, inputTypeHierarchy, ((GenericArrayType)inType).getGenericComponentType(), componentInfo);
        }
        if (inTypeInfo instanceof TupleTypeInfo && TypeExtractionUtils.isClassType(inType) && Tuple.class.isAssignableFrom(TypeExtractionUtils.typeToClass(inType))) {
            while (!TypeExtractionUtils.isClassType(inType) || !TypeExtractionUtils.typeToClass(inType).getSuperclass().equals(Tuple.class)) {
                inputTypeHierarchy.add(inType);
                inType = TypeExtractionUtils.typeToClass(inType).getGenericSuperclass();
            }
            inputTypeHierarchy.add(inType);
            ParameterizedType tupleBaseClass = (ParameterizedType)inType;
            Type[] tupleElements = tupleBaseClass.getActualTypeArguments();
            int i = 0;
            while (i < tupleElements.length) {
                info = this.createTypeInfoFromInput(returnTypeVar, inputTypeHierarchy, tupleElements[i], ((TupleTypeInfo)inTypeInfo).getTypeAt(i));
                if (info != null) return info;
                ++i;
            }
            return info;
        }
        if (!(inTypeInfo instanceof PojoTypeInfo)) return info;
        if (!TypeExtractionUtils.isClassType(inType)) return info;
        TypeExtractionUtils.getTypeHierarchy(inputTypeHierarchy, inType, Object.class);
        List<Field> fields2 = TypeExtractor.getAllDeclaredFields(TypeExtractionUtils.typeToClass(inType), false);
        Iterator<Field> iterator = fields2.iterator();
        while (iterator.hasNext()) {
            Field field = iterator.next();
            Type fieldType = field.getGenericType();
            if (fieldType instanceof TypeVariable && TypeExtractionUtils.sameTypeVars(returnTypeVar, TypeExtractor.materializeTypeVariable(inputTypeHierarchy, (TypeVariable)fieldType))) {
                return TypeExtractor.getTypeOfPojoField(inTypeInfo, field);
            }
            if (!(fieldType instanceof ParameterizedType) && !(fieldType instanceof GenericArrayType)) continue;
            ArrayList<Type> typeHierarchyWithFieldType = new ArrayList<Type>(inputTypeHierarchy);
            typeHierarchyWithFieldType.add(fieldType);
            TypeInformation<?> foundInfo = this.createTypeInfoFromInput(returnTypeVar, typeHierarchyWithFieldType, fieldType, TypeExtractor.getTypeOfPojoField(inTypeInfo, field));
            if (foundInfo != null) return foundInfo;
        }
        return info;
    }

    private <IN1, IN2> TypeInformation<?>[] createSubTypesInfo(Type originalType, ParameterizedType definingType, ArrayList<Type> typeHierarchy, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type, boolean lenient) {
        Type[] subtypes = new Type[definingType.getActualTypeArguments().length];
        for (int i = 0; i < subtypes.length; ++i) {
            Type actualTypeArg = definingType.getActualTypeArguments()[i];
            subtypes[i] = actualTypeArg instanceof TypeVariable ? TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)actualTypeArg) : actualTypeArg;
        }
        TypeInformation[] subTypesInfo = new TypeInformation[subtypes.length];
        for (int i = 0; i < subtypes.length; ++i) {
            ArrayList<Type> subTypeHierarchy = new ArrayList<Type>(typeHierarchy);
            subTypeHierarchy.add(subtypes[i]);
            if (subtypes[i] instanceof TypeVariable) {
                subTypesInfo[i] = this.createTypeInfoFromInputs((TypeVariable)subtypes[i], subTypeHierarchy, in1Type, in2Type);
                if (subTypesInfo[i] != null || lenient) continue;
                throw new InvalidTypesException("Type of TypeVariable '" + ((TypeVariable)subtypes[i]).getName() + "' in '" + ((TypeVariable)subtypes[i]).getGenericDeclaration() + "' could not be determined. This is most likely a type erasure problem. The type extraction currently supports types with generic variables only in cases where all variables in the return type can be deduced from the input type(s). Otherwise the type has to be specified explicitly using type information.");
            }
            try {
                subTypesInfo[i] = this.createTypeInfoWithTypeHierarchy(subTypeHierarchy, subtypes[i], in1Type, in2Type);
                continue;
            }
            catch (InvalidTypesException e2) {
                if (lenient) {
                    subTypesInfo[i] = null;
                    continue;
                }
                throw e2;
            }
        }
        if (!lenient) {
            Class<?> originalTypeAsClass = null;
            if (TypeExtractionUtils.isClassType(originalType)) {
                originalTypeAsClass = TypeExtractionUtils.typeToClass(originalType);
            }
            Preconditions.checkNotNull(originalTypeAsClass, "originalType has an unexpected type");
            int fieldCount = this.countFieldsInClass(originalTypeAsClass);
            if (fieldCount > subTypesInfo.length) {
                return null;
            }
        }
        return subTypesInfo;
    }

    private <IN1, IN2, OUT> TypeInformation<OUT> createTypeInfoFromFactory(Type t, ArrayList<Type> typeHierarchy, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        TypeInformation<OUT> createdTypeInfo;
        Map<String, TypeInformation<?>> genericParams;
        ArrayList<Type> factoryHierarchy = new ArrayList<Type>(typeHierarchy);
        TypeInfoFactory<OUT> factory = TypeExtractor.getClosestFactory(factoryHierarchy, t);
        if (factory == null) {
            return null;
        }
        Type factoryDefiningType = factoryHierarchy.get(factoryHierarchy.size() - 1);
        if (factoryDefiningType instanceof ParameterizedType) {
            genericParams = new HashMap();
            ParameterizedType paramDefiningType = (ParameterizedType)factoryDefiningType;
            TypeVariable<Class<?>>[] args = TypeExtractionUtils.typeToClass(paramDefiningType).getTypeParameters();
            TypeInformation<?>[] subtypeInfo = this.createSubTypesInfo(t, paramDefiningType, factoryHierarchy, in1Type, in2Type, true);
            assert (subtypeInfo != null);
            for (int i = 0; i < subtypeInfo.length; ++i) {
                genericParams.put(args[i].toString(), subtypeInfo[i]);
            }
        } else {
            genericParams = Collections.emptyMap();
        }
        if ((createdTypeInfo = factory.createTypeInfo(t, genericParams)) == null) {
            throw new InvalidTypesException("TypeInfoFactory returned invalid TypeInformation 'null'");
        }
        return createdTypeInfo;
    }

    @PublicEvolving
    public static Type getParameterType(Class<?> baseClass, Class<?> clazz, int pos) {
        return TypeExtractor.getParameterType(baseClass, null, clazz, pos);
    }

    private static Type getParameterType(Class<?> baseClass, ArrayList<Type> typeHierarchy, Class<?> clazz, int pos) {
        Type[] interfaceTypes;
        if (typeHierarchy != null) {
            typeHierarchy.add(clazz);
        }
        for (Type t : interfaceTypes = clazz.getGenericInterfaces()) {
            Type parameter = TypeExtractor.getParameterTypeFromGenericType(baseClass, typeHierarchy, t, pos);
            if (parameter == null) continue;
            return parameter;
        }
        Type t = clazz.getGenericSuperclass();
        Type parameter = TypeExtractor.getParameterTypeFromGenericType(baseClass, typeHierarchy, t, pos);
        if (parameter != null) {
            return parameter;
        }
        throw new InvalidTypesException("The types of the interface " + baseClass.getName() + " could not be inferred. Support for synthetic interfaces, lambdas, and generic or raw types is limited at this point");
    }

    private static Type getParameterTypeFromGenericType(Class<?> baseClass, ArrayList<Type> typeHierarchy, Type t, int pos) {
        if (t instanceof ParameterizedType && baseClass.equals(((ParameterizedType)t).getRawType())) {
            if (typeHierarchy != null) {
                typeHierarchy.add(t);
            }
            ParameterizedType baseClassChild = (ParameterizedType)t;
            return baseClassChild.getActualTypeArguments()[pos];
        }
        if (t instanceof ParameterizedType && baseClass.isAssignableFrom((Class)((ParameterizedType)t).getRawType())) {
            if (typeHierarchy != null) {
                typeHierarchy.add(t);
            }
            return TypeExtractor.getParameterType(baseClass, typeHierarchy, (Class)((ParameterizedType)t).getRawType(), pos);
        }
        if (t instanceof Class && baseClass.isAssignableFrom((Class)t)) {
            if (typeHierarchy != null) {
                typeHierarchy.add(t);
            }
            return TypeExtractor.getParameterType(baseClass, typeHierarchy, (Class)t, pos);
        }
        return null;
    }

    private static void validateInputType(Type t, TypeInformation<?> inType) {
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        try {
            TypeExtractor.validateInfo(typeHierarchy, t, inType);
        }
        catch (InvalidTypesException e2) {
            throw new InvalidTypesException("Input mismatch: " + e2.getMessage(), e2);
        }
    }

    private static void validateInputType(Class<?> baseClass, Class<?> clazz, int inputParamPos, TypeInformation<?> inTypeInfo) {
        Type inType;
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        try {
            inType = TypeExtractor.getParameterType(baseClass, typeHierarchy, clazz, inputParamPos);
        }
        catch (InvalidTypesException e2) {
            return;
        }
        try {
            TypeExtractor.validateInfo(typeHierarchy, inType, inTypeInfo);
        }
        catch (InvalidTypesException e3) {
            throw new InvalidTypesException("Input mismatch: " + e3.getMessage(), e3);
        }
    }

    private static void validateInfo(ArrayList<Type> typeHierarchy, Type type, TypeInformation<?> typeInfo) {
        block35: {
            block33: {
                block42: {
                    Class<?> clazz;
                    block43: {
                        block41: {
                            block40: {
                                block39: {
                                    Type component;
                                    block38: {
                                        Type component2;
                                        block37: {
                                            block36: {
                                                SqlTimeTypeInfo actual;
                                                block34: {
                                                    BasicTypeInfo actual2;
                                                    if (type == null) {
                                                        throw new InvalidTypesException("Unknown Error. Type is null.");
                                                    }
                                                    if (typeInfo == null) {
                                                        throw new InvalidTypesException("Unknown Error. TypeInformation is null.");
                                                    }
                                                    if (type instanceof TypeVariable) break block33;
                                                    if (!(typeInfo instanceof BasicTypeInfo)) break block34;
                                                    if (!(type instanceof Class) || (actual2 = BasicTypeInfo.getInfoFor((Class)type)) == null) {
                                                        throw new InvalidTypesException("Basic type expected.");
                                                    }
                                                    if (!typeInfo.equals(actual2)) {
                                                        throw new InvalidTypesException("Basic type '" + typeInfo + "' expected but was '" + actual2 + "'.");
                                                    }
                                                    break block35;
                                                }
                                                if (!(typeInfo instanceof SqlTimeTypeInfo)) break block36;
                                                if (!(type instanceof Class) || (actual = SqlTimeTypeInfo.getInfoFor((Class)type)) == null) {
                                                    throw new InvalidTypesException("SQL time type expected.");
                                                }
                                                if (!typeInfo.equals(actual)) {
                                                    throw new InvalidTypesException("SQL time type '" + typeInfo + "' expected but was '" + actual + "'.");
                                                }
                                                break block35;
                                            }
                                            if (!(typeInfo instanceof TupleTypeInfo)) break block37;
                                            if (!TypeExtractionUtils.isClassType(type) || !Tuple.class.isAssignableFrom(TypeExtractionUtils.typeToClass(type))) {
                                                throw new InvalidTypesException("Tuple type expected.");
                                            }
                                            if (TypeExtractionUtils.isClassType(type) && TypeExtractionUtils.typeToClass(type).equals(Tuple.class)) {
                                                throw new InvalidTypesException("Concrete subclass of Tuple expected.");
                                            }
                                            while (!TypeExtractionUtils.isClassType(type) || !TypeExtractionUtils.typeToClass(type).getSuperclass().equals(Tuple.class)) {
                                                typeHierarchy.add(type);
                                                type = TypeExtractionUtils.typeToClass(type).getGenericSuperclass();
                                            }
                                            if (type == Tuple0.class) {
                                                return;
                                            }
                                            if (type instanceof Class) {
                                                throw new InvalidTypesException("Parameterized Tuple type expected.");
                                            }
                                            TupleTypeInfo tti = (TupleTypeInfo)typeInfo;
                                            Type[] subTypes = ((ParameterizedType)type).getActualTypeArguments();
                                            if (subTypes.length != tti.getArity()) {
                                                throw new InvalidTypesException("Tuple arity '" + tti.getArity() + "' expected but was '" + subTypes.length + "'.");
                                            }
                                            for (int i = 0; i < subTypes.length; ++i) {
                                                TypeExtractor.validateInfo(new ArrayList<Type>(typeHierarchy), subTypes[i], tti.getTypeAt(i));
                                            }
                                            break block35;
                                        }
                                        if (!(typeInfo instanceof PrimitiveArrayTypeInfo)) break block38;
                                        if (!(type instanceof Class && ((Class)type).isArray() && (component2 = ((Class)type).getComponentType()) != null || type instanceof GenericArrayType && (component2 = ((GenericArrayType)type).getGenericComponentType()) != null)) {
                                            throw new InvalidTypesException("Array type expected.");
                                        }
                                        if (component2 instanceof TypeVariable && (component2 = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)component2)) instanceof TypeVariable) {
                                            return;
                                        }
                                        if (!(component2 instanceof Class) || !component2.isPrimitive()) {
                                            throw new InvalidTypesException("Primitive component expected.");
                                        }
                                        break block35;
                                    }
                                    if (!(typeInfo instanceof BasicArrayTypeInfo)) break block39;
                                    if (!(type instanceof Class && ((Class)type).isArray() && (component = ((Class)type).getComponentType()) != null || type instanceof GenericArrayType && (component = ((GenericArrayType)type).getGenericComponentType()) != null)) {
                                        throw new InvalidTypesException("Array type expected.");
                                    }
                                    if (component instanceof TypeVariable && (component = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)component)) instanceof TypeVariable) {
                                        return;
                                    }
                                    TypeExtractor.validateInfo(typeHierarchy, component, ((BasicArrayTypeInfo)typeInfo).getComponentInfo());
                                    break block35;
                                }
                                if (!(typeInfo instanceof ObjectArrayTypeInfo)) break block40;
                                if (!(type instanceof Class && ((Class)type).isArray() || type instanceof GenericArrayType)) {
                                    throw new InvalidTypesException("Object array type expected.");
                                }
                                Type component = type instanceof Class ? ((Class)type).getComponentType() : ((GenericArrayType)type).getGenericComponentType();
                                if (component instanceof TypeVariable && (component = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)component)) instanceof TypeVariable) {
                                    return;
                                }
                                TypeExtractor.validateInfo(typeHierarchy, component, ((ObjectArrayTypeInfo)typeInfo).getComponentInfo());
                                break block35;
                            }
                            if (!(typeInfo instanceof ValueTypeInfo)) break block41;
                            if (!(type instanceof Class) || !Value.class.isAssignableFrom((Class)type)) {
                                throw new InvalidTypesException("Value type expected.");
                            }
                            TypeInformation actual = ValueTypeInfo.getValueTypeInfo((Class)type);
                            if (!((ValueTypeInfo)typeInfo).equals(actual)) {
                                throw new InvalidTypesException("Value type '" + typeInfo + "' expected but was '" + actual + "'.");
                            }
                            break block35;
                        }
                        if (!(typeInfo instanceof PojoTypeInfo)) break block42;
                        clazz = null;
                        if (!TypeExtractionUtils.isClassType(type)) break block43;
                        clazz = TypeExtractionUtils.typeToClass(type);
                        if (((PojoTypeInfo)typeInfo).getTypeClass() == clazz) break block35;
                    }
                    throw new InvalidTypesException("POJO type '" + ((PojoTypeInfo)typeInfo).getTypeClass().getCanonicalName() + "' expected but was '" + clazz.getCanonicalName() + "'.");
                }
                if (typeInfo instanceof EnumTypeInfo) {
                    if (!(type instanceof Class) || !Enum.class.isAssignableFrom((Class)type)) {
                        throw new InvalidTypesException("Enum type expected.");
                    }
                    if (typeInfo.getTypeClass() != type) {
                        throw new InvalidTypesException("Enum type '" + typeInfo.getTypeClass().getCanonicalName() + "' expected but was '" + TypeExtractionUtils.typeToClass(type).getCanonicalName() + "'.");
                    }
                } else if (typeInfo instanceof GenericTypeInfo) {
                    Class clazz = null;
                    if (!TypeExtractionUtils.isClassType(type) || !(clazz = TypeExtractionUtils.typeToClass(type)).isAssignableFrom(((GenericTypeInfo)typeInfo).getTypeClass())) {
                        throw new InvalidTypesException("Generic type '" + ((GenericTypeInfo)typeInfo).getTypeClass().getCanonicalName() + "' or a subclass of it expected but was '" + clazz.getCanonicalName() + "'.");
                    }
                } else {
                    TypeExtractor.validateIfWritable(typeInfo, type);
                }
                break block35;
            }
            if (!((type = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)type)) instanceof TypeVariable)) {
                TypeExtractor.validateInfo(typeHierarchy, type, typeInfo);
            }
        }
    }

    private static void validateInputContainsExecutable(TypeExtractionUtils.LambdaExecutable exec, TypeInformation<?> typeInfo) {
        Constructor<?>[] constructors;
        List<Method> methods = TypeExtractionUtils.getAllDeclaredMethods(typeInfo.getTypeClass());
        for (Method method : methods) {
            if (!exec.executablesEquals(method)) continue;
            return;
        }
        for (Constructor<?> constructor : constructors = typeInfo.getTypeClass().getDeclaredConstructors()) {
            if (!exec.executablesEquals(constructor)) continue;
            return;
        }
        throw new InvalidTypesException("Type contains no executable '" + exec.getName() + "'.");
    }

    @Internal
    public static <OUT> TypeInfoFactory<OUT> getTypeInfoFactory(Type t) {
        Class<? extends TypeInfoFactory> factoryClass;
        if (registeredTypeInfoFactories.containsKey(t)) {
            factoryClass = registeredTypeInfoFactories.get(t);
        } else {
            if (!TypeExtractionUtils.isClassType(t) || !TypeExtractionUtils.typeToClass(t).isAnnotationPresent(TypeInfo.class)) {
                return null;
            }
            TypeInfo typeInfoAnnotation = TypeExtractionUtils.typeToClass(t).getAnnotation(TypeInfo.class);
            factoryClass = typeInfoAnnotation.value();
            if (!TypeInfoFactory.class.isAssignableFrom(factoryClass)) {
                throw new InvalidTypesException("TypeInfo annotation does not specify a valid TypeInfoFactory.");
            }
        }
        return InstantiationUtil.instantiate(factoryClass);
    }

    private static int countTypeInHierarchy(ArrayList<Type> typeHierarchy, Type type) {
        int count = 0;
        for (Type t : typeHierarchy) {
            if (t != type && (!TypeExtractionUtils.isClassType(type) || t != TypeExtractionUtils.typeToClass(type)) && (!TypeExtractionUtils.isClassType(t) || TypeExtractionUtils.typeToClass(t) != type)) continue;
            ++count;
        }
        return count;
    }

    private static <OUT> TypeInfoFactory<? super OUT> getClosestFactory(ArrayList<Type> typeHierarchy, Type t) {
        TypeInfoFactory<OUT> factory = null;
        while (factory == null && TypeExtractionUtils.isClassType(t) && !TypeExtractionUtils.typeToClass(t).equals(Object.class)) {
            typeHierarchy.add(t);
            factory = TypeExtractor.getTypeInfoFactory(t);
            if ((t = TypeExtractionUtils.typeToClass(t).getGenericSuperclass()) != null) continue;
            break;
        }
        return factory;
    }

    private int countFieldsInClass(Class<?> clazz) {
        int fieldCount = 0;
        for (Field field : clazz.getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            ++fieldCount;
        }
        return fieldCount;
    }

    private static Type materializeTypeVariable(ArrayList<Type> typeHierarchy, TypeVariable<?> typeVar) {
        TypeVariable inTypeTypeVar = typeVar;
        for (int i = typeHierarchy.size() - 1; i >= 0; --i) {
            Type curT = typeHierarchy.get(i);
            if (!(curT instanceof ParameterizedType)) continue;
            Class rawType = (Class)((ParameterizedType)curT).getRawType();
            for (int paramIndex = 0; paramIndex < rawType.getTypeParameters().length; ++paramIndex) {
                TypeVariable curVarOfCurT = rawType.getTypeParameters()[paramIndex];
                if (!TypeExtractionUtils.sameTypeVars(curVarOfCurT, inTypeTypeVar)) continue;
                Type curVarType = ((ParameterizedType)curT).getActualTypeArguments()[paramIndex];
                if (curVarType instanceof TypeVariable) {
                    inTypeTypeVar = (TypeVariable)curVarType;
                    continue;
                }
                return curVarType;
            }
        }
        return inTypeTypeVar;
    }

    public static <X> TypeInformation<X> getForClass(Class<X> clazz) {
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        typeHierarchy.add(clazz);
        return new TypeExtractor().privateGetForClass(clazz, typeHierarchy);
    }

    private <X> TypeInformation<X> privateGetForClass(Class<X> clazz, ArrayList<Type> typeHierarchy) {
        return this.privateGetForClass(clazz, typeHierarchy, null, null, null);
    }

    private <OUT, IN1, IN2> TypeInformation<OUT> privateGetForClass(Class<OUT> clazz, ArrayList<Type> typeHierarchy, ParameterizedType parameterizedType, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        block19: {
            Preconditions.checkNotNull(clazz);
            TypeInformation<OUT> typeFromFactory = this.createTypeInfoFromFactory(clazz, typeHierarchy, in1Type, in2Type);
            if (typeFromFactory != null) {
                return typeFromFactory;
            }
            if (clazz.equals(Object.class)) {
                return new GenericTypeInfo<OUT>(clazz);
            }
            if (clazz.equals(Class.class)) {
                return new GenericTypeInfo<OUT>(clazz);
            }
            if (TypeExtractor.countTypeInHierarchy(typeHierarchy, clazz) > 1) {
                return new GenericTypeInfo<OUT>(clazz);
            }
            if (clazz.isArray()) {
                PrimitiveArrayTypeInfo<OUT> primitiveArrayInfo = PrimitiveArrayTypeInfo.getInfoFor(clazz);
                if (primitiveArrayInfo != null) {
                    return primitiveArrayInfo;
                }
                BasicArrayTypeInfo basicArrayInfo = BasicArrayTypeInfo.getInfoFor(clazz);
                if (basicArrayInfo != null) {
                    return basicArrayInfo;
                }
                TypeInformation<OUT> componentTypeInfo = this.createTypeInfoWithTypeHierarchy(typeHierarchy, clazz.getComponentType(), in1Type, in2Type);
                return ObjectArrayTypeInfo.getInfoFor(clazz, componentTypeInfo);
            }
            if (TypeExtractor.isHadoopWritable(clazz)) {
                return TypeExtractor.createHadoopWritableTypeInfo(clazz);
            }
            BasicTypeInfo<OUT> basicTypeInfo = BasicTypeInfo.getInfoFor(clazz);
            if (basicTypeInfo != null) {
                return basicTypeInfo;
            }
            SqlTimeTypeInfo<OUT> timeTypeInfo = SqlTimeTypeInfo.getInfoFor(clazz);
            if (timeTypeInfo != null) {
                return timeTypeInfo;
            }
            if (Value.class.isAssignableFrom(clazz)) {
                Class<Value> valueClass = clazz.asSubclass(Value.class);
                return ValueTypeInfo.getValueTypeInfo(valueClass);
            }
            if (Tuple.class.isAssignableFrom(clazz)) {
                if (clazz == Tuple0.class) {
                    return new TupleTypeInfo<Tuple0>(Tuple0.class, new TypeInformation[0]);
                }
                throw new InvalidTypesException("Type information extraction for tuples (except Tuple0) cannot be done based on the class.");
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                return new EnumTypeInfo<OUT>(clazz);
            }
            if (TypeExtractionUtils.hasSuperclass(clazz, AVRO_SPECIFIC_RECORD_BASE_CLASS)) {
                return AvroUtils.getAvroUtils().createAvroTypeInfo(clazz);
            }
            if (Modifier.isInterface(clazz.getModifiers())) {
                return new GenericTypeInfo<OUT>(clazz);
            }
            try {
                TypeInformation<OUT> pojoType = this.analyzePojo(clazz, new ArrayList<Type>(typeHierarchy), parameterizedType, in1Type, in2Type);
                if (pojoType != null) {
                    return pojoType;
                }
            }
            catch (InvalidTypesException e2) {
                if (!LOG.isDebugEnabled()) break block19;
                LOG.debug("Unable to handle type " + clazz + " as POJO. Message: " + e2.getMessage(), (Throwable)e2);
            }
        }
        return new GenericTypeInfo<OUT>(clazz);
    }

    private boolean isValidPojoField(Field f, Class<?> clazz, ArrayList<Type> typeHierarchy) {
        if (Modifier.isPublic(f.getModifiers())) {
            return true;
        }
        boolean hasGetter = false;
        boolean hasSetter = false;
        String fieldNameLow = f.getName().toLowerCase().replaceAll("_", "");
        Type fieldType = f.getGenericType();
        Class fieldTypeWrapper = ClassUtils.primitiveToWrapper(f.getType());
        TypeVariable fieldTypeGeneric = null;
        if (fieldType instanceof TypeVariable) {
            fieldTypeGeneric = (TypeVariable)fieldType;
            fieldType = TypeExtractor.materializeTypeVariable(typeHierarchy, (TypeVariable)fieldType);
        }
        for (Method m : clazz.getMethods()) {
            String methodNameLow;
            String string = methodNameLow = m.getName().endsWith("_$eq") ? m.getName().toLowerCase().replaceAll("_", "").replaceFirst("\\$eq$", "_\\$eq") : m.getName().toLowerCase().replaceAll("_", "");
            if ((methodNameLow.equals("get" + fieldNameLow) || methodNameLow.equals("is" + fieldNameLow) || methodNameLow.equals(fieldNameLow)) && m.getParameterTypes().length == 0 && (m.getGenericReturnType().equals(fieldType) || fieldTypeWrapper != null && m.getReturnType().equals(fieldTypeWrapper) || fieldTypeGeneric != null && m.getGenericReturnType().equals(fieldTypeGeneric))) {
                hasGetter = true;
            }
            if (!methodNameLow.equals("set" + fieldNameLow) && !methodNameLow.equals(fieldNameLow + "_$eq") || m.getParameterTypes().length != 1 || !m.getGenericParameterTypes()[0].equals(fieldType) && (fieldTypeWrapper == null || !m.getParameterTypes()[0].equals(fieldTypeWrapper)) && (fieldTypeGeneric == null || !m.getGenericParameterTypes()[0].equals(fieldTypeGeneric)) || !m.getReturnType().equals(Void.TYPE)) continue;
            hasSetter = true;
        }
        if (hasGetter && hasSetter) {
            return true;
        }
        if (!hasGetter) {
            LOG.info(clazz + " does not contain a getter for field " + f.getName());
        }
        if (!hasSetter) {
            LOG.info(clazz + " does not contain a setter for field " + f.getName());
        }
        return false;
    }

    protected <OUT, IN1, IN2> TypeInformation<OUT> analyzePojo(Class<OUT> clazz, ArrayList<Type> typeHierarchy, ParameterizedType parameterizedType, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            LOG.info("Class " + clazz.getName() + " is not public so it cannot be used as a POJO type and must be processed as GenericType. Please read the Flink documentation on \"Data Types & Serialization\" for details of the effect on performance.");
            return new GenericTypeInfo<OUT>(clazz);
        }
        if (parameterizedType != null) {
            TypeExtractionUtils.getTypeHierarchy(typeHierarchy, parameterizedType, Object.class);
        } else if (typeHierarchy.size() <= 1) {
            TypeExtractionUtils.getTypeHierarchy(typeHierarchy, clazz, Object.class);
        }
        List<Field> fields2 = TypeExtractor.getAllDeclaredFields(clazz, false);
        if (fields2.size() == 0) {
            LOG.info("No fields were detected for " + clazz + " so it cannot be used as a POJO type and must be processed as GenericType. Please read the Flink documentation on \"Data Types & Serialization\" for details of the effect on performance.");
            return new GenericTypeInfo<OUT>(clazz);
        }
        ArrayList<PojoField> pojoFields = new ArrayList<PojoField>();
        for (Field field : fields2) {
            Type fieldType = field.getGenericType();
            if (!this.isValidPojoField(field, clazz, typeHierarchy)) {
                LOG.info("Class " + clazz + " cannot be used as a POJO type because not all fields are valid POJO fields, and must be processed as GenericType. Please read the Flink documentation on \"Data Types & Serialization\" for details of the effect on performance.");
                return null;
            }
            try {
                ArrayList<Type> fieldTypeHierarchy = new ArrayList<Type>(typeHierarchy);
                fieldTypeHierarchy.add(fieldType);
                TypeInformation<OUT> ti = this.createTypeInfoWithTypeHierarchy(fieldTypeHierarchy, fieldType, in1Type, in2Type);
                pojoFields.add(new PojoField(field, ti));
            }
            catch (InvalidTypesException e2) {
                Class genericClass = Object.class;
                if (TypeExtractionUtils.isClassType(fieldType)) {
                    genericClass = TypeExtractionUtils.typeToClass(fieldType);
                }
                pojoFields.add(new PojoField(field, new GenericTypeInfo<Object>(genericClass)));
            }
        }
        PojoTypeInfo<OUT> pojoType = new PojoTypeInfo<OUT>(clazz, pojoFields);
        List<Method> methods = TypeExtractionUtils.getAllDeclaredMethods(clazz);
        for (Method method : methods) {
            if (!method.getName().equals("readObject") && !method.getName().equals("writeObject")) continue;
            LOG.info("Class " + clazz + " contains custom serialization methods we do not call, so it cannot be used as a POJO type and must be processed as GenericType. Please read the Flink documentation on \"Data Types & Serialization\" for details of the effect on performance.");
            return null;
        }
        Constructor<OUT> defaultConstructor = null;
        try {
            defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e3) {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                LOG.info(clazz + " is abstract or an interface, having a concrete type can increase performance.");
            }
            LOG.info(clazz + " is missing a default constructor so it cannot be used as a POJO type and must be processed as GenericType. Please read the Flink documentation on \"Data Types & Serialization\" for details of the effect on performance.");
            return null;
        }
        if (defaultConstructor != null && !Modifier.isPublic(defaultConstructor.getModifiers())) {
            LOG.info("The default constructor of " + clazz + " is not Public so it cannot be used as a POJO type and must be processed as GenericType. Please read the Flink documentation on \"Data Types & Serialization\" for details of the effect on performance.");
            return null;
        }
        return pojoType;
    }

    @PublicEvolving
    public static List<Field> getAllDeclaredFields(Class<?> clazz, boolean ignoreDuplicates) {
        ArrayList<Field> result = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields2;
            for (Field field : fields2 = clazz.getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                if (TypeExtractor.hasFieldWithSameName(field.getName(), result)) {
                    if (ignoreDuplicates) continue;
                    throw new InvalidTypesException("The field " + field + " is already contained in the hierarchy of the " + clazz + ".Please use unique field names through your classes hierarchy");
                }
                result.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    @PublicEvolving
    public static Field getDeclaredField(Class<?> clazz, String name) {
        for (Field field : TypeExtractor.getAllDeclaredFields(clazz, true)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    private static boolean hasFieldWithSameName(String name, List<Field> fields2) {
        for (Field field : fields2) {
            if (!name.equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    private static TypeInformation<?> getTypeOfPojoField(TypeInformation<?> pojoInfo, Field field) {
        for (int j2 = 0; j2 < pojoInfo.getArity(); ++j2) {
            PojoField pf = ((PojoTypeInfo)pojoInfo).getPojoFieldAt(j2);
            if (!pf.getField().getName().equals(field.getName())) continue;
            return pf.getTypeInformation();
        }
        return null;
    }

    public static <X> TypeInformation<X> getForObject(X value) {
        return new TypeExtractor().privateGetForObject(value);
    }

    private <X> TypeInformation<X> privateGetForObject(X value) {
        Preconditions.checkNotNull(value);
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        typeHierarchy.add(value.getClass());
        TypeInformation typeFromFactory = this.createTypeInfoFromFactory(value.getClass(), typeHierarchy, null, null);
        if (typeFromFactory != null) {
            return typeFromFactory;
        }
        if (value instanceof Tuple) {
            Tuple t = (Tuple)value;
            int numFields = t.getArity();
            if (numFields != this.countFieldsInClass(value.getClass())) {
                return this.analyzePojo(value.getClass(), new ArrayList<Type>(), null, null, null);
            }
            TypeInformation[] infos = new TypeInformation[numFields];
            for (int i = 0; i < numFields; ++i) {
                Object field = t.getField(i);
                if (field == null) {
                    throw new InvalidTypesException("Automatic type extraction is not possible on candidates with null values. Please specify the types directly.");
                }
                infos[i] = this.privateGetForObject(field);
            }
            return new TupleTypeInfo(value.getClass(), infos);
        }
        if (value instanceof Row) {
            Row row2 = (Row)value;
            int arity = row2.getArity();
            for (int i = 0; i < arity; ++i) {
                if (row2.getField(i) != null) continue;
                LOG.warn("Cannot extract type of Row field, because of Row field[" + i + "] is null. Should define RowTypeInfo explicitly.");
                return this.privateGetForClass(value.getClass(), new ArrayList<Type>());
            }
            TypeInformation[] typeArray = new TypeInformation[arity];
            for (int i = 0; i < arity; ++i) {
                typeArray[i] = TypeExtractor.getForObject(row2.getField(i));
            }
            return new RowTypeInfo(typeArray);
        }
        return this.privateGetForClass(value.getClass(), new ArrayList<Type>());
    }

    static boolean isHadoopWritable(Class<?> typeClass) {
        if (typeClass.getName().equals(HADOOP_WRITABLE_CLASS)) {
            return false;
        }
        HashSet alreadySeen = new HashSet();
        alreadySeen.add(typeClass);
        return TypeExtractor.hasHadoopWritableInterface(typeClass, alreadySeen);
    }

    private static boolean hasHadoopWritableInterface(Class<?> clazz, HashSet<Class<?>> alreadySeen) {
        Class<?>[] interfaces;
        for (Class<?> c : interfaces = clazz.getInterfaces()) {
            if (c.getName().equals(HADOOP_WRITABLE_CLASS)) {
                return true;
            }
            if (!alreadySeen.add(c) || !TypeExtractor.hasHadoopWritableInterface(c, alreadySeen)) continue;
            return true;
        }
        Class<?> superclass = clazz.getSuperclass();
        return superclass != null && alreadySeen.add(superclass) && TypeExtractor.hasHadoopWritableInterface(superclass, alreadySeen);
    }

    public static <T> TypeInformation<T> createHadoopWritableTypeInfo(Class<T> clazz) {
        Class<?> typeInfoClass;
        Preconditions.checkNotNull(clazz);
        try {
            typeInfoClass = Class.forName(HADOOP_WRITABLE_TYPEINFO_CLASS, false, TypeExtractor.class.getClassLoader());
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException("Could not load the TypeInformation for the class 'org.apache.hadoop.io.Writable'. You may be missing the 'flink-hadoop-compatibility' dependency.");
        }
        try {
            Constructor<?> constr = typeInfoClass.getConstructor(Class.class);
            TypeInformation typeInfo = (TypeInformation)constr.newInstance(clazz);
            return typeInfo;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e3) {
            throw new RuntimeException("Incompatible versions of the Hadoop Compatibility classes found.");
        }
        catch (InvocationTargetException e4) {
            throw new RuntimeException("Cannot create Hadoop WritableTypeInfo.", e4.getTargetException());
        }
    }

    static void validateIfWritable(TypeInformation<?> typeInfo, Type type) {
        try {
            Class<?> writableTypeInfoClass = Class.forName(HADOOP_WRITABLE_TYPEINFO_CLASS, false, typeInfo.getClass().getClassLoader());
            if (writableTypeInfoClass.isAssignableFrom(typeInfo.getClass())) {
                if (!(type instanceof Class) || !TypeExtractor.isHadoopWritable((Class)type)) {
                    throw new InvalidTypesException("org.apache.hadoop.io.Writable type expected.");
                }
                Class clazz = (Class)type;
                if (typeInfo.getTypeClass() != clazz) {
                    throw new InvalidTypesException("Writable type '" + typeInfo.getTypeClass().getCanonicalName() + "' expected but was '" + clazz.getCanonicalName() + "'.");
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

