/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.ConfigGroup;
import org.apache.flink.annotation.docs.ConfigGroups;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;

@ConfigGroups(groups={@ConfigGroup(name="Environment", keyPrefix="env"), @ConfigGroup(name="FileSystem", keyPrefix="fs")})
@PublicEvolving
public class CoreOptions {
    public static final ConfigOption<String> CLASSLOADER_RESOLVE_ORDER = ConfigOptions.key("classloader.resolve-order").defaultValue("child-first").withDescription("Defines the class resolution strategy when loading classes from user code, meaning whether to first check the user code jar (\"child-first\") or the application classpath (\"parent-first\"). The default settings indicate to load classes first from the user code jar, which means that user code jars can include and load different dependencies than Flink uses (transitively).");
    public static final ConfigOption<String> ALWAYS_PARENT_FIRST_LOADER_PATTERNS = ConfigOptions.key("classloader.parent-first-patterns.default").defaultValue("java.;scala.;org.apache.flink.;com.esotericsoftware.kryo;org.apache.hadoop.;javax.annotation.;org.slf4j;org.apache.log4j;org.apache.logging;org.apache.commons.logging;ch.qos.logback").withDeprecatedKeys("classloader.parent-first-patterns").withDescription("A (semicolon-separated) list of patterns that specifies which classes should always be resolved through the parent ClassLoader first. A pattern is a simple prefix that is checked against the fully qualified class name. This setting should generally not be modified. To add another pattern we recommend to use \"classloader.parent-first-patterns.additional\" instead.");
    public static final ConfigOption<String> ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL = ConfigOptions.key("classloader.parent-first-patterns.additional").defaultValue("").withDescription("A (semicolon-separated) list of patterns that specifies which classes should always be resolved through the parent ClassLoader first. A pattern is a simple prefix that is checked against the fully qualified class name. These patterns are appended to \"" + ALWAYS_PARENT_FIRST_LOADER_PATTERNS.key() + "\".");
    public static final ConfigOption<String> FLINK_JVM_OPTIONS = ConfigOptions.key("env.java.opts").defaultValue("");
    public static final ConfigOption<String> FLINK_JM_JVM_OPTIONS = ConfigOptions.key("env.java.opts.jobmanager").defaultValue("");
    public static final ConfigOption<String> FLINK_TM_JVM_OPTIONS = ConfigOptions.key("env.java.opts.taskmanager").defaultValue("");
    public static final ConfigOption<String> FLINK_LOG_DIR = ConfigOptions.key("env.log.dir").noDefaultValue().withDescription("Defines the directory where the Flink logs are saved. It has to be an absolute path. (Defaults to the log directory under Flink\u2019s home)");
    public static final ConfigOption<Integer> FLINK_LOG_MAX = ConfigOptions.key("env.log.max").defaultValue(5).withDescription("The maximum number of old log files to keep.");
    public static final ConfigOption<String> FLINK_SSH_OPTIONS = ConfigOptions.key("env.ssh.opts").noDefaultValue().withDescription("Additional command line options passed to SSH clients when starting or stopping JobManager, TaskManager, and Zookeeper services (start-cluster.sh, stop-cluster.sh, start-zookeeper-quorum.sh, stop-zookeeper-quorum.sh).");
    @Documentation.OverrideDefault(value="System.getProperty(\"java.io.tmpdir\")")
    public static final ConfigOption<String> TMP_DIRS = ConfigOptions.key("io.tmp.dirs").defaultValue(System.getProperty("java.io.tmpdir")).withDeprecatedKeys("taskmanager.tmp.dirs");
    public static final ConfigOption<Boolean> STDOUT_ROTATION_ENABLED = ConfigOptions.key("stdout.rotation.enabled").defaultValue(true);
    public static final ConfigOption<Boolean> STDERR_ROTATION_ENABLED = ConfigOptions.key("stderr.rotation.enabled").defaultValue(true);
    public static final ConfigOption<Integer> DEFAULT_PARALLELISM = ConfigOptions.key("parallelism.default").defaultValue(1);
    public static final ConfigOption<String> DEFAULT_PARTITIONER = ConfigOptions.key("partitioner.default").defaultValue("REBALANCE").withDescription("The default stream partitioner, used when the upstream and downstream parallelisms are not equal and partitioner is not specified. Possible values are 'RESCALE' and 'REBALANCE'.");
    public static final ConfigOption<Boolean> CHAIN_EAGERLY_ENABLED = ConfigOptions.key("chain.eagerly.enabled").defaultValue(false).withDescription("Whether operators are chained more eagerly when the parallelism is one");
    public static final ConfigOption<Double> DEFAULT_RESOURCE_CPU_CORES = ConfigOptions.key("resource.cpu.cores.default").defaultValue(0.01).withDescription("CPU cores for operators, use double so we can specify cpu like 0.1.");
    public static final ConfigOption<Integer> DEFAULT_RESOURCE_HEAP_MEMORY = ConfigOptions.key("resource.heap.mb.default").defaultValue(16).withDescription("Java heap size (in megabytes) for operators.");
    public static final ConfigOption<Boolean> DEFAULT_ENABLE_SHAREDSLOT = ConfigOptions.key("sharedslot-enabled.default").defaultValue(true);
    public static final ConfigOption<Boolean> CHECKPOINT_LOCK_ENABLE_FAIRNESS = ConfigOptions.key("checkpoint-lock.enable-fairness").defaultValue(false);
    public static final ConfigOption<String> DEFAULT_FILESYSTEM_SCHEME = ConfigOptions.key("fs.default-scheme").noDefaultValue().withDescription("The default filesystem scheme, used for paths that do not declare a scheme explicitly. May contain an authority, e.g. host:port in case of a HDFS NameNode.");
    public static final ConfigOption<Boolean> FILESYTEM_DEFAULT_OVERRIDE = ConfigOptions.key("fs.overwrite-files").defaultValue(false).withDescription("Specifies whether file output writers should overwrite existing files by default. Set to \"true\" to overwrite by default,\"false\" otherwise.");
    public static final ConfigOption<Boolean> FILESYSTEM_OUTPUT_ALWAYS_CREATE_DIRECTORY = ConfigOptions.key("fs.output.always-create-directory").defaultValue(false).withDescription("File writers running with a parallelism larger than one create a directory for the output file path and put the different result files (one per parallel writer task) into that directory. If this option is set to \"true\", writers with a parallelism of 1 will also create a directory and place a single result file into it. If the option is set to \"false\", the writer will directly create the file directly at the output path, without creating a containing directory.");
    public static final String NEW_MODE = "new";
    public static final String LEGACY_MODE = "legacy";
    public static final ConfigOption<String> MODE = ConfigOptions.key("mode").defaultValue("new").withDescription("Switch to select the execution mode. Possible values are 'new' and 'legacy'.");
    public static final ConfigOption<Boolean> DISABLE_UPLOAD_USER_JARS = ConfigOptions.key("user-jars.upload.disabled").defaultValue(false);
    public static final ConfigOption<Long> CLUSTER_IDLE_TIMEOUT = ConfigOptions.key("cluster.idle-timeout").defaultValue(-1L).withDescription("The idle timeout in milliseconds for cluster, only worked for kubernetes session cluster which will be destroyed after expiration. Defaults to -1, which means there is no expiration.");
    public static final ConfigOption<String> PRE_GENERATED_JOB_ID = ConfigOptions.key("pre-generated.job-id").noDefaultValue().withDescription("The pre-generated job id, which will be used to generate job graph. By default, a random job id will be used.");

    public static String[] getParentFirstLoaderPatterns(Configuration config) {
        String[] basePatterns;
        String base = config.getString(ALWAYS_PARENT_FIRST_LOADER_PATTERNS);
        String append = config.getString(ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL);
        String[] stringArray = basePatterns = base.isEmpty() ? new String[]{} : base.split(";");
        if (append.isEmpty()) {
            return basePatterns;
        }
        String[] appendPatterns = append.split(";");
        String[] joinedPatterns = new String[basePatterns.length + appendPatterns.length];
        System.arraycopy(basePatterns, 0, joinedPatterns, 0, basePatterns.length);
        System.arraycopy(appendPatterns, 0, joinedPatterns, basePatterns.length, appendPatterns.length);
        return joinedPatterns;
    }

    public static ConfigOption<Integer> fileSystemConnectionLimit(String scheme) {
        return ConfigOptions.key("fs." + scheme + ".limit.total").defaultValue(-1);
    }

    public static ConfigOption<Integer> fileSystemConnectionLimitIn(String scheme) {
        return ConfigOptions.key("fs." + scheme + ".limit.input").defaultValue(-1);
    }

    public static ConfigOption<Integer> fileSystemConnectionLimitOut(String scheme) {
        return ConfigOptions.key("fs." + scheme + ".limit.output").defaultValue(-1);
    }

    public static ConfigOption<Long> fileSystemConnectionLimitTimeout(String scheme) {
        return ConfigOptions.key("fs." + scheme + ".limit.timeout").defaultValue(0L);
    }

    public static ConfigOption<Long> fileSystemConnectionLimitStreamInactivityTimeout(String scheme) {
        return ConfigOptions.key("fs." + scheme + ".limit.stream-timeout").defaultValue(0L);
    }
}

