/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.InternalBackendSerializationProxy;
import org.apache.flink.runtime.state.PriorityQueueStateMetaInfoSnapshot;
import org.apache.flink.runtime.state.StateMetaInfoSnapshot;

public class RocksDBInternalBackendSerializationProxy
extends InternalBackendSerializationProxy {
    public static final int VERSION = 2;
    private List<PriorityQueueStateMetaInfoSnapshot> priorityQueueStateMetaInfoSnapshots;

    public RocksDBInternalBackendSerializationProxy(ClassLoader userCodeClassLoader, boolean isSerializerPresenceRequired) {
        super(userCodeClassLoader, isSerializerPresenceRequired);
        this.priorityQueueStateMetaInfoSnapshots = new ArrayList<PriorityQueueStateMetaInfoSnapshot>();
    }

    public RocksDBInternalBackendSerializationProxy(List<StateMetaInfoSnapshot> keyedStateMetaSnapshots, List<StateMetaInfoSnapshot> subKeyedStateMetaSnapshots, List<PriorityQueueStateMetaInfoSnapshot> priorityQueueStateMetaInfoSnapshots, boolean compression) {
        super(keyedStateMetaSnapshots, subKeyedStateMetaSnapshots, compression);
        this.priorityQueueStateMetaInfoSnapshots = priorityQueueStateMetaInfoSnapshots;
    }

    public int getVersion() {
        return 2;
    }

    public int[] getCompatibleVersions() {
        return new int[]{1, 2};
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.writePriorityQueues(out);
    }

    public void read(DataInputView in) throws IOException {
        super.read(in);
        if (this.getReadVersion() == 2) {
            this.readPriorityQueues(in);
        }
    }

    private void writePriorityQueues(DataOutputView out) throws IOException {
        out.writeShort(this.priorityQueueStateMetaInfoSnapshots.size());
        for (PriorityQueueStateMetaInfoSnapshot stateMetaInfoSnapshot : this.priorityQueueStateMetaInfoSnapshots) {
            stateMetaInfoSnapshot.write(out);
        }
    }

    private void readPriorityQueues(DataInputView in) throws IOException {
        int stateSize = in.readShort();
        for (int i = 0; i < stateSize; ++i) {
            this.priorityQueueStateMetaInfoSnapshots.add(PriorityQueueStateMetaInfoSnapshot.read((DataInputView)in, (ClassLoader)this.userCodeClassLoader));
        }
    }

    List<PriorityQueueStateMetaInfoSnapshot> getPriorityQueueStateMetaInfoSnapshots() {
        return this.priorityQueueStateMetaInfoSnapshots;
    }
}

