/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.contrib.streaming.state.OptionsFactory;
import org.apache.flink.contrib.streaming.state.PredefinedOptions;
import org.apache.flink.contrib.streaming.state.RocksDBInternalStateBackend;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.contrib.streaming.state.RocksDBOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractInternalStateBackend;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.DefaultOperatorStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TernaryBoolean;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.NativeLibraryLoader;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBStateBackend
extends AbstractStateBackend
implements ConfigurableStateBackend {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBStateBackend.class);
    @VisibleForTesting
    static final int ROCKSDB_LIB_LOADING_ATTEMPTS = 3;
    private static boolean rocksDbInitialized = false;
    private static final int UNDEFINED_NUMBER_OF_RESTORING_THREADS = -1;
    private final StateBackend checkpointStreamBackend;
    @Nullable
    private File[] localRocksDbDirectories;
    private PredefinedOptions predefinedOptions = PredefinedOptions.DEFAULT;
    @Nullable
    private OptionsFactory optionsFactory;
    private final TernaryBoolean enableIncrementalCheckpointing;
    private final PriorityQueueStateType priorityQueueStateType;
    private int numberOfRestoringThreads;
    private transient File[] initializedDbBasePaths;
    private transient JobID jobId;
    private transient int nextDirectory;
    private transient boolean isInitialized;

    public RocksDBStateBackend(String checkpointDataUri) throws IOException {
        this(new Path(checkpointDataUri).toUri());
    }

    public RocksDBStateBackend(String checkpointDataUri, boolean enableIncrementalCheckpointing) throws IOException {
        this(new Path(checkpointDataUri).toUri(), enableIncrementalCheckpointing);
    }

    public RocksDBStateBackend(URI checkpointDataUri) throws IOException {
        this((AbstractStateBackend)new FsStateBackend(checkpointDataUri));
    }

    public RocksDBStateBackend(URI checkpointDataUri, boolean enableIncrementalCheckpointing) throws IOException {
        this((AbstractStateBackend)new FsStateBackend(checkpointDataUri), enableIncrementalCheckpointing);
    }

    public RocksDBStateBackend(StateBackend checkpointStreamBackend) {
        this(checkpointStreamBackend, TernaryBoolean.UNDEFINED);
    }

    public RocksDBStateBackend(StateBackend checkpointStreamBackend, TernaryBoolean enableIncrementalCheckpointing) {
        this.checkpointStreamBackend = Preconditions.checkNotNull(checkpointStreamBackend);
        this.enableIncrementalCheckpointing = enableIncrementalCheckpointing;
        this.numberOfRestoringThreads = -1;
        this.priorityQueueStateType = PriorityQueueStateType.HEAP;
    }

    @Deprecated
    public RocksDBStateBackend(AbstractStateBackend checkpointStreamBackend) {
        this((StateBackend)checkpointStreamBackend, TernaryBoolean.UNDEFINED);
    }

    @Deprecated
    public RocksDBStateBackend(AbstractStateBackend checkpointStreamBackend, boolean enableIncrementalCheckpointing) {
        this((StateBackend)checkpointStreamBackend, TernaryBoolean.fromBoolean(enableIncrementalCheckpointing));
    }

    private RocksDBStateBackend(RocksDBStateBackend original, Configuration config) {
        StateBackend originalStreamBackend = original.checkpointStreamBackend;
        this.checkpointStreamBackend = originalStreamBackend instanceof ConfigurableStateBackend ? ((ConfigurableStateBackend)originalStreamBackend).configure(config) : originalStreamBackend;
        this.enableIncrementalCheckpointing = original.enableIncrementalCheckpointing.resolveUndefined(config.getBoolean(CheckpointingOptions.INCREMENTAL_CHECKPOINTS));
        String priorityQueueTypeString = config.getString(RocksDBOptions.PRIORITY_QUEUE_STATE_TYPE);
        this.priorityQueueStateType = priorityQueueTypeString.length() > 0 ? PriorityQueueStateType.valueOf(priorityQueueTypeString.toUpperCase()) : original.priorityQueueStateType;
        this.numberOfRestoringThreads = original.numberOfRestoringThreads == -1 ? config.getInteger(RocksDBOptions.CHECKPOINT_RESTORE_THREAD_NUM) : original.numberOfRestoringThreads;
        if (original.localRocksDbDirectories != null) {
            this.localRocksDbDirectories = original.localRocksDbDirectories;
        } else {
            String rocksdbLocalPaths = config.getString(RocksDBOptions.ROCKSDB_LOCAL_DIRECTORIES);
            if (rocksdbLocalPaths != null) {
                String[] directories = rocksdbLocalPaths.split(",|" + File.pathSeparator);
                try {
                    this.setDbStoragePaths(directories);
                }
                catch (IllegalArgumentException e2) {
                    throw new IllegalConfigurationException("Invalid configuration for RocksDB state backend's local storage directories: " + e2.getMessage(), e2);
                }
            }
        }
        this.predefinedOptions = original.predefinedOptions;
        this.optionsFactory = original.optionsFactory;
    }

    public RocksDBStateBackend configure(Configuration config) {
        return new RocksDBStateBackend(this, config);
    }

    public StateBackend getCheckpointBackend() {
        return this.checkpointStreamBackend;
    }

    private void lazyInitializeForJob(Environment env, String operatorIdentifier) throws IOException {
        if (this.isInitialized) {
            return;
        }
        this.jobId = env.getJobID();
        if (this.localRocksDbDirectories == null) {
            String[] workingDirs = ConfigurationUtils.parseWorkingDirectories(env.getTaskManagerInfo().getConfiguration());
            if (workingDirs.length == 0) {
                this.initializedDbBasePaths = env.getIOManager().getSpillingDirectories();
                this.nextDirectory = ThreadLocalRandom.current().nextInt(this.initializedDbBasePaths.length);
                this.isInitialized = true;
                return;
            }
            this.setDbStoragePaths(workingDirs);
        }
        ArrayList<File> dirs = new ArrayList<File>(this.localRocksDbDirectories.length);
        StringBuilder errorMessage = new StringBuilder();
        for (File f : this.localRocksDbDirectories) {
            File testDir = new File(f, UUID.randomUUID().toString());
            if (!testDir.mkdirs()) {
                String msg = "Local DB files directory '" + f + "' does not exist and cannot be created. ";
                LOG.error(msg);
                errorMessage.append(msg);
            } else {
                dirs.add(f);
            }
            testDir.delete();
        }
        if (dirs.isEmpty()) {
            throw new IOException("No local storage directories available. " + errorMessage);
        }
        this.initializedDbBasePaths = dirs.toArray(new File[dirs.size()]);
        this.nextDirectory = ThreadLocalRandom.current().nextInt(this.initializedDbBasePaths.length);
        this.isInitialized = true;
    }

    private File getNextStoragePath() {
        int ni = this.nextDirectory + 1;
        this.nextDirectory = ni = ni >= this.initializedDbBasePaths.length ? 0 : ni;
        return this.initializedDbBasePaths[ni];
    }

    public CompletedCheckpointStorageLocation resolveCheckpoint(String pointer) throws IOException {
        return this.checkpointStreamBackend.resolveCheckpoint(pointer);
    }

    public CheckpointStorage createCheckpointStorage(JobID jobId) throws IOException {
        return this.checkpointStreamBackend.createCheckpointStorage(jobId);
    }

    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry) throws IOException {
        String tempDir = env.getTaskManagerInfo().getTmpDirectories()[0];
        this.ensureRocksDBIsLoaded(tempDir);
        String fileCompatibleIdentifier = operatorIdentifier.replaceAll("[^a-zA-Z0-9\\-]", "_");
        this.lazyInitializeForJob(env, fileCompatibleIdentifier);
        File instanceBasePath = new File(this.getNextStoragePath(), "job_" + this.jobId + "_op_" + fileCompatibleIdentifier + "_uuid_" + UUID.randomUUID());
        LocalRecoveryConfig localRecoveryConfig = env.getTaskStateManager().createLocalRecoveryConfig();
        return new RocksDBKeyedStateBackend<K>(operatorIdentifier, env.getUserClassLoader(), instanceBasePath, this.getDbOptions(), this.getColumnOptions(), kvStateRegistry, keySerializer, numberOfKeyGroups, keyGroupRange, env.getExecutionConfig(), this.isIncrementalCheckpointsEnabled(), localRecoveryConfig);
    }

    public OperatorStateBackend createOperatorStateBackend(Environment env, String operatorIdentifier) throws Exception {
        boolean asyncSnapshots = true;
        return new DefaultOperatorStateBackend(env.getUserClassLoader(), env.getExecutionConfig(), true);
    }

    public AbstractInternalStateBackend createInternalStateBackend(Environment env, String operatorIdentifier, int numberOfGroups, KeyGroupRange keyGroupRange, MetricGroup metricGroup) throws IOException {
        String tempDir = env.getTaskManagerInfo().getTmpDirectories()[0];
        this.ensureRocksDBIsLoaded(tempDir);
        String fileCompatibleIdentifier = operatorIdentifier.replaceAll("[^a-zA-Z0-9\\-]", "_");
        this.lazyInitializeForJob(env, fileCompatibleIdentifier);
        File instanceBasePath = new File(this.getNextStoragePath(), "job_" + this.jobId + "_op_" + fileCompatibleIdentifier + "_uuid_" + UUID.randomUUID());
        LocalRecoveryConfig localRecoveryConfig = env.getTaskStateManager().createLocalRecoveryConfig();
        return new RocksDBInternalStateBackend(env.getUserClassLoader(), instanceBasePath, this.getDbOptions(), this.getColumnOptions(), numberOfGroups, keyGroupRange, this.isIncrementalCheckpointsEnabled(), this.getNumberOfRestoringThreads(), localRecoveryConfig, this.priorityQueueStateType, env.getTaskKvStateRegistry(), env.getExecutionConfig(), fileCompatibleIdentifier);
    }

    public int getNumberOfRestoringThreads() {
        return this.numberOfRestoringThreads == -1 ? RocksDBOptions.CHECKPOINT_RESTORE_THREAD_NUM.defaultValue() : this.numberOfRestoringThreads;
    }

    public void setNumberOfRestoringThreads(int numberOfRestoringThreads) {
        Preconditions.checkArgument(numberOfRestoringThreads > 0, "The number of threads used to download files from DFS in RocksDBStateBackend should bigger than zero.");
        this.numberOfRestoringThreads = numberOfRestoringThreads;
    }

    public void setDbStoragePath(String path) {
        String[] stringArray;
        if (path == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = path;
        }
        this.setDbStoragePaths(stringArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDbStoragePaths(String ... paths) {
        if (paths == null) {
            this.localRocksDbDirectories = null;
            return;
        }
        if (paths.length == 0) {
            throw new IllegalArgumentException("empty paths");
        }
        File[] pp = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path;
            String rawPath = paths[i];
            if (rawPath == null) {
                throw new IllegalArgumentException("null path");
            }
            URI uri = null;
            try {
                uri = new Path(rawPath).toUri();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uri != null && uri.getScheme() != null) {
                if (!"file".equalsIgnoreCase(uri.getScheme())) throw new IllegalArgumentException("Path " + rawPath + " has a non-local scheme");
                path = uri.getPath();
            } else {
                path = rawPath;
            }
            pp[i] = new File(path);
            if (pp[i].isAbsolute()) continue;
            throw new IllegalArgumentException("Relative paths are not supported");
        }
        this.localRocksDbDirectories = pp;
    }

    public String[] getDbStoragePaths() {
        if (this.localRocksDbDirectories == null) {
            return null;
        }
        String[] paths = new String[this.localRocksDbDirectories.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = this.localRocksDbDirectories[i].toString();
        }
        return paths;
    }

    public boolean isIncrementalCheckpointsEnabled() {
        return this.enableIncrementalCheckpointing.getOrDefault(CheckpointingOptions.INCREMENTAL_CHECKPOINTS.defaultValue());
    }

    public void setPredefinedOptions(PredefinedOptions options) {
        this.predefinedOptions = Preconditions.checkNotNull(options);
    }

    public PredefinedOptions getPredefinedOptions() {
        return this.predefinedOptions;
    }

    public void setOptions(OptionsFactory optionsFactory) {
        this.optionsFactory = optionsFactory;
    }

    public OptionsFactory getOptions() {
        return this.optionsFactory;
    }

    public DBOptions getDbOptions() {
        DBOptions opt = this.predefinedOptions.createDBOptions();
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createDBOptions(opt);
        }
        opt = opt.setCreateIfMissing(true);
        return opt;
    }

    public ColumnFamilyOptions getColumnOptions() {
        ColumnFamilyOptions opt = this.predefinedOptions.createColumnOptions();
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createColumnOptions(opt);
        }
        return opt;
    }

    public String toString() {
        return "RocksDBStateBackend{checkpointStreamBackend=" + this.checkpointStreamBackend + ", localRocksDbDirectories=" + Arrays.toString(this.localRocksDbDirectories) + ", enableIncrementalCheckpointing=" + (Object)((Object)this.enableIncrementalCheckpointing) + ", numberOfRestoringThreads=" + this.numberOfRestoringThreads + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureRocksDBIsLoaded(String tempDirectory) throws IOException {
        Class<RocksDBStateBackend> clazz = RocksDBStateBackend.class;
        synchronized (RocksDBStateBackend.class) {
            if (!rocksDbInitialized) {
                File tempDirParent = new File(tempDirectory).getAbsoluteFile();
                LOG.info("Attempting to load RocksDB native library and store it under '{}'", (Object)tempDirParent);
                Throwable lastException = null;
                for (int attempt = 1; attempt <= 3; ++attempt) {
                    File rocksLibFolder = null;
                    try {
                        rocksLibFolder = this.createRocksDBLibDir(tempDirParent);
                        NativeLibraryLoader.getInstance().loadLibrary(rocksLibFolder.getAbsolutePath());
                        RocksDB.loadLibrary();
                        LOG.info("Successfully loaded RocksDB native library");
                        rocksDbInitialized = true;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    catch (Throwable t) {
                        lastException = t;
                        LOG.debug("RocksDB JNI library loading attempt {} failed", (Object)attempt, (Object)t);
                        try {
                            RocksDBStateBackend.resetRocksDBLoadedFlag();
                        }
                        catch (Throwable tt) {
                            LOG.debug("Failed to reset 'initialized' flag in RocksDB native code loader", tt);
                        }
                        FileUtils.deleteDirectoryQuietly(rocksLibFolder);
                        continue;
                    }
                }
                throw new IOException("Could not load the native RocksDB library", lastException);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @VisibleForTesting
    File createRocksDBLibDir(File tempDirParent) {
        File rocksLibFolder = new File(tempDirParent, "rocksdb-lib-" + new AbstractID());
        LOG.debug("Attempting to create RocksDB native library folder {}", (Object)rocksLibFolder);
        rocksLibFolder.mkdirs();
        rocksLibFolder.deleteOnExit();
        return rocksLibFolder;
    }

    @VisibleForTesting
    static void resetRocksDBLoadedFlag() throws Exception {
        Field initField = NativeLibraryLoader.class.getDeclaredField("initialized");
        initField.setAccessible(true);
        initField.setBoolean(null, false);
    }

    public static enum PriorityQueueStateType {
        HEAP,
        ROCKSDB;

    }
}

