/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import org.apache.flink.contrib.streaming.state.RocksDBPair;
import org.apache.flink.contrib.streaming.state.RocksDBStorageInstance;
import org.apache.flink.contrib.streaming.state.RocksDBStoragePrefixIterator;
import org.apache.flink.contrib.streaming.state.RocksDBStorageRangeIterator;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.StorageInstance;
import org.apache.flink.runtime.state.StorageIterator;
import org.apache.flink.types.Pair;
import org.rocksdb.RocksIterator;

public class RocksDBStateStorage
implements StateStorage<byte[], byte[]> {
    private final RocksDBStorageInstance storageInstance;

    public RocksDBStateStorage(RocksDBStorageInstance storageInstance) {
        this.storageInstance = storageInstance;
    }

    public void put(byte[] key, byte[] value) throws Exception {
        this.storageInstance.put(key, value);
    }

    public byte[] get(byte[] key) throws Exception {
        return this.storageInstance.get(key);
    }

    public boolean remove(byte[] key) {
        this.storageInstance.delete(key);
        return true;
    }

    public StorageIterator<byte[], byte[]> iterator() {
        return new RocksDBStoragePrefixIterator(this.storageInstance, null);
    }

    public StorageIterator<byte[], byte[]> prefixIterator(byte[] prefixKey) {
        return new RocksDBStoragePrefixIterator(this.storageInstance, prefixKey);
    }

    public StorageIterator<byte[], byte[]> subIterator(byte[] prefixKeyStart, byte[] prefixKeyEnd) {
        return new RocksDBStorageRangeIterator(this.storageInstance, prefixKeyStart, prefixKeyEnd);
    }

    public Pair<byte[], byte[]> firstEntry(byte[] prefixKeys) {
        try (RocksIterator iterator = this.storageInstance.iterator();){
            iterator.seek(prefixKeys);
            if (iterator.isValid()) {
                RocksDBPair rocksDBPair = new RocksDBPair(this.storageInstance, iterator.key(), iterator.value());
                return rocksDBPair;
            }
            Pair<byte[], byte[]> pair = null;
            return pair;
        }
    }

    public Pair<byte[], byte[]> lastEntry(byte[] prefixKeys) {
        try (RocksIterator iterator = this.storageInstance.iterator();){
            iterator.seek(prefixKeys);
            if (iterator.isValid()) {
                iterator.prev();
            } else {
                iterator.seekToLast();
            }
            if (iterator.isValid()) {
                RocksDBPair rocksDBPair = new RocksDBPair(this.storageInstance, iterator.key(), iterator.value());
                return rocksDBPair;
            }
            Pair<byte[], byte[]> pair = null;
            return pair;
        }
    }

    public void merge(byte[] key, byte[] value) {
        this.storageInstance.merge(key, value);
    }

    public boolean lazySerde() {
        return false;
    }

    public boolean supportMultiColumnFamilies() {
        return true;
    }

    public StorageInstance getStorageInstance() {
        return this.storageInstance;
    }
}

