/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import org.apache.flink.contrib.streaming.state.AbstractRocksDbStorageIterator;
import org.apache.flink.contrib.streaming.state.RocksDBPair;
import org.apache.flink.contrib.streaming.state.RocksDBStorageInstance;
import org.apache.flink.runtime.state.StorageIterator;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public class RocksDBStorageRangeIterator
implements StorageIterator<byte[], byte[]> {
    private final RocksDBStorageInstance dbStorageInstance;
    private final AbstractRocksDbStorageIterator<RocksDBPair> rangeIterator;

    public RocksDBStorageRangeIterator(RocksDBStorageInstance dbStorageInstance, final byte[] keyPrefixStart, final byte[] keyPrefixEnd) {
        Preconditions.checkState(this.compare(keyPrefixStart, keyPrefixEnd) <= 0);
        this.dbStorageInstance = dbStorageInstance;
        this.rangeIterator = new AbstractRocksDbStorageIterator<RocksDBPair>(dbStorageInstance){

            @Override
            byte[] getStartDBKey() {
                return keyPrefixStart;
            }

            @Override
            boolean isEndDBKey(byte[] dbKey) {
                return RocksDBStorageRangeIterator.this.compare(dbKey, keyPrefixEnd) >= 0;
            }

            @Override
            public RocksDBPair next() {
                return this.getNextPair();
            }
        };
    }

    public void close() throws Exception {
    }

    public boolean hasNext() {
        return this.rangeIterator.hasNext();
    }

    public Pair<byte[], byte[]> next() {
        return (Pair)this.rangeIterator.next();
    }

    public void remove() {
        this.rangeIterator.remove();
    }

    private int compare(byte[] leftBytes, byte[] rightBytes) {
        Preconditions.checkArgument(leftBytes != null);
        Preconditions.checkArgument(rightBytes != null);
        int commonLength = Math.min(leftBytes.length, rightBytes.length);
        for (int i = 0; i < commonLength; ++i) {
            int leftByte = leftBytes[i] & 0xFF;
            int rightByte = rightBytes[i] & 0xFF;
            if (leftByte > rightByte) {
                return 1;
            }
            if (leftByte >= rightByte) continue;
            return -1;
        }
        return leftBytes.length - rightBytes.length;
    }
}

